package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{AccountId, GraphArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetMembersRequest(
    graphArn: GraphArn,
    accountIds: Iterable[AccountId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.GetMembersRequest = {
    import GetMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.GetMembersRequest
      .builder()
      .graphArn(GraphArn.unwrap(graphArn): java.lang.String)
      .accountIds(accountIds.map { item =>
        AccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.GetMembersRequest.ReadOnly =
    zio.aws.detective.model.GetMembersRequest.wrap(buildAwsValue())
}
object GetMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.GetMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.GetMembersRequest =
      zio.aws.detective.model.GetMembersRequest(graphArn, accountIds)
    def graphArn: GraphArn
    def accountIds: List[AccountId]
    def getGraphArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(graphArn)
    def getAccountIds: ZIO[Any, Nothing, List[AccountId]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.GetMembersRequest
  ) extends zio.aws.detective.model.GetMembersRequest.ReadOnly {
    override val graphArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.graphArn())
    override val accountIds: List[AccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.detective.model.primitives.AccountId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.GetMembersRequest
  ): zio.aws.detective.model.GetMembersRequest.ReadOnly = new Wrapper(impl)
}
