package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{Timestamp, GraphArn}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Graph(
    arn: Option[GraphArn] = None,
    createdTime: Option[Timestamp] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.detective.model.Graph = {
    import Graph.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.Graph
      .builder()
      .optionallyWith(
        arn.map(value => GraphArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.Graph.ReadOnly =
    zio.aws.detective.model.Graph.wrap(buildAwsValue())
}
object Graph {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.detective.model.Graph] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.Graph = zio.aws.detective.model
      .Graph(arn.map(value => value), createdTime.map(value => value))
    def arn: Option[GraphArn]
    def createdTime: Option[Timestamp]
    def getArn: ZIO[Any, AwsError, GraphArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.Graph
  ) extends zio.aws.detective.model.Graph.ReadOnly {
    override val arn: Option[GraphArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.detective.model.primitives.GraphArn(value))
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.detective.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.Graph
  ): zio.aws.detective.model.Graph.ReadOnly = new Wrapper(impl)
}
