package zio.aws.detective.model
import scala.jdk.CollectionConverters.*
sealed trait InvitationType {
  def unwrap: software.amazon.awssdk.services.detective.model.InvitationType
}
object InvitationType {
  def wrap(
      value: software.amazon.awssdk.services.detective.model.InvitationType
  ): zio.aws.detective.model.InvitationType = value match {
    case software.amazon.awssdk.services.detective.model.InvitationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.detective.model.InvitationType.INVITATION =>
      val r = INVITATION
      r
    case software.amazon.awssdk.services.detective.model.InvitationType.ORGANIZATION =>
      val r = ORGANIZATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.detective.model.InvitationType {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.InvitationType =
      software.amazon.awssdk.services.detective.model.InvitationType.UNKNOWN_TO_SDK_VERSION
  }
  case object INVITATION extends zio.aws.detective.model.InvitationType {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.InvitationType =
      software.amazon.awssdk.services.detective.model.InvitationType.INVITATION
  }
  case object ORGANIZATION extends zio.aws.detective.model.InvitationType {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.InvitationType =
      software.amazon.awssdk.services.detective.model.InvitationType.ORGANIZATION
  }
}
