package zio.aws.detective.model
import java.lang.Integer
import zio.ZIO
import zio.aws.detective.model.primitives.{MemberResultsLimit, PaginationToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListGraphsRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MemberResultsLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.ListGraphsRequest = {
    import ListGraphsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.ListGraphsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MemberResultsLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.ListGraphsRequest.ReadOnly =
    zio.aws.detective.model.ListGraphsRequest.wrap(buildAwsValue())
}
object ListGraphsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.ListGraphsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.ListGraphsRequest =
      zio.aws.detective.model.ListGraphsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MemberResultsLimit]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MemberResultsLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.ListGraphsRequest
  ) extends zio.aws.detective.model.ListGraphsRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.detective.model.primitives.PaginationToken(value))
    override val maxResults: Option[MemberResultsLimit] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.detective.model.primitives.MemberResultsLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.ListGraphsRequest
  ): zio.aws.detective.model.ListGraphsRequest.ReadOnly = new Wrapper(impl)
}
