package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListGraphsResponse(
    graphList: Option[Iterable[zio.aws.detective.model.Graph]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.ListGraphsResponse = {
    import ListGraphsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.ListGraphsResponse
      .builder()
      .optionallyWith(
        graphList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.graphList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.ListGraphsResponse.ReadOnly =
    zio.aws.detective.model.ListGraphsResponse.wrap(buildAwsValue())
}
object ListGraphsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.ListGraphsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.ListGraphsResponse =
      zio.aws.detective.model.ListGraphsResponse(
        graphList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def graphList: Option[List[zio.aws.detective.model.Graph.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getGraphList
        : ZIO[Any, AwsError, List[zio.aws.detective.model.Graph.ReadOnly]] =
      AwsError.unwrapOptionField("graphList", graphList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.ListGraphsResponse
  ) extends zio.aws.detective.model.ListGraphsResponse.ReadOnly {
    override val graphList
        : Option[List[zio.aws.detective.model.Graph.ReadOnly]] = scala
      .Option(impl.graphList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.detective.model.Graph.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.detective.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.ListGraphsResponse
  ): zio.aws.detective.model.ListGraphsResponse.ReadOnly = new Wrapper(impl)
}
