package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListMembersResponse(
    memberDetails: Option[Iterable[zio.aws.detective.model.MemberDetail]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.ListMembersResponse = {
    import ListMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.ListMembersResponse
      .builder()
      .optionallyWith(
        memberDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memberDetails)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.ListMembersResponse.ReadOnly =
    zio.aws.detective.model.ListMembersResponse.wrap(buildAwsValue())
}
object ListMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.ListMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.ListMembersResponse =
      zio.aws.detective.model.ListMembersResponse(
        memberDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def memberDetails
        : Option[List[zio.aws.detective.model.MemberDetail.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getMemberDetails: ZIO[Any, AwsError, List[
      zio.aws.detective.model.MemberDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("memberDetails", memberDetails)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.ListMembersResponse
  ) extends zio.aws.detective.model.ListMembersResponse.ReadOnly {
    override val memberDetails
        : Option[List[zio.aws.detective.model.MemberDetail.ReadOnly]] = scala
      .Option(impl.memberDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.detective.model.MemberDetail.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.detective.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.ListMembersResponse
  ): zio.aws.detective.model.ListMembersResponse.ReadOnly = new Wrapper(impl)
}
