package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListOrganizationAdminAccountsResponse(
    administrators: Option[Iterable[zio.aws.detective.model.Administrator]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.ListOrganizationAdminAccountsResponse = {
    import ListOrganizationAdminAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.ListOrganizationAdminAccountsResponse
      .builder()
      .optionallyWith(
        administrators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.administrators)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.ListOrganizationAdminAccountsResponse.ReadOnly =
    zio.aws.detective.model.ListOrganizationAdminAccountsResponse
      .wrap(buildAwsValue())
}
object ListOrganizationAdminAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.ListOrganizationAdminAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.detective.model.ListOrganizationAdminAccountsResponse =
      zio.aws.detective.model.ListOrganizationAdminAccountsResponse(
        administrators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def administrators
        : Option[List[zio.aws.detective.model.Administrator.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getAdministrators: ZIO[Any, AwsError, List[
      zio.aws.detective.model.Administrator.ReadOnly
    ]] = AwsError.unwrapOptionField("administrators", administrators)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.ListOrganizationAdminAccountsResponse
  ) extends zio.aws.detective.model.ListOrganizationAdminAccountsResponse.ReadOnly {
    override val administrators
        : Option[List[zio.aws.detective.model.Administrator.ReadOnly]] = scala
      .Option(impl.administrators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.detective.model.Administrator.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.detective.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.ListOrganizationAdminAccountsResponse
  ): zio.aws.detective.model.ListOrganizationAdminAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
