package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.GraphArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: GraphArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(GraphArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.detective.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.ListTagsForResourceRequest =
      zio.aws.detective.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: GraphArn
    def getResourceArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.ListTagsForResourceRequest
  ) extends zio.aws.detective.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.ListTagsForResourceRequest
  ): zio.aws.detective.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
