package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{
  EmailAddress,
  AccountId,
  Percentage,
  ByteValue,
  Timestamp,
  GraphArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class MemberDetail(
    accountId: Option[AccountId] = None,
    emailAddress: Option[EmailAddress] = None,
    graphArn: Option[GraphArn] = None,
    masterId: Option[AccountId] = None,
    administratorId: Option[AccountId] = None,
    status: Option[zio.aws.detective.model.MemberStatus] = None,
    disabledReason: Option[zio.aws.detective.model.MemberDisabledReason] = None,
    invitedTime: Option[Timestamp] = None,
    updatedTime: Option[Timestamp] = None,
    volumeUsageInBytes: Option[ByteValue] = None,
    volumeUsageUpdatedTime: Option[Timestamp] = None,
    percentOfGraphUtilization: Option[Percentage] = None,
    percentOfGraphUtilizationUpdatedTime: Option[Timestamp] = None,
    invitationType: Option[zio.aws.detective.model.InvitationType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.MemberDetail = {
    import MemberDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.MemberDetail
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        emailAddress.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        graphArn.map(value => GraphArn.unwrap(value): java.lang.String)
      )(_.graphArn)
      .optionallyWith(
        masterId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.masterId)
      .optionallyWith(
        administratorId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.administratorId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(disabledReason.map(value => value.unwrap))(
        _.disabledReason
      )
      .optionallyWith(
        invitedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.invitedTime)
      .optionallyWith(
        updatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.updatedTime)
      .optionallyWith(
        volumeUsageInBytes.map(value => ByteValue.unwrap(value): java.lang.Long)
      )(_.volumeUsageInBytes)
      .optionallyWith(
        volumeUsageUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.volumeUsageUpdatedTime)
      .optionallyWith(
        percentOfGraphUtilization.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.percentOfGraphUtilization)
      .optionallyWith(
        percentOfGraphUtilizationUpdatedTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.percentOfGraphUtilizationUpdatedTime)
      .optionallyWith(invitationType.map(value => value.unwrap))(
        _.invitationType
      )
      .build()
  }
  def asReadOnly: zio.aws.detective.model.MemberDetail.ReadOnly =
    zio.aws.detective.model.MemberDetail.wrap(buildAwsValue())
}
object MemberDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.MemberDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.MemberDetail =
      zio.aws.detective.model.MemberDetail(
        accountId.map(value => value),
        emailAddress.map(value => value),
        graphArn.map(value => value),
        masterId.map(value => value),
        administratorId.map(value => value),
        status.map(value => value),
        disabledReason.map(value => value),
        invitedTime.map(value => value),
        updatedTime.map(value => value),
        volumeUsageInBytes.map(value => value),
        volumeUsageUpdatedTime.map(value => value),
        percentOfGraphUtilization.map(value => value),
        percentOfGraphUtilizationUpdatedTime.map(value => value),
        invitationType.map(value => value)
      )
    def accountId: Option[AccountId]
    def emailAddress: Option[EmailAddress]
    def graphArn: Option[GraphArn]
    def masterId: Option[AccountId]
    def administratorId: Option[AccountId]
    def status: Option[zio.aws.detective.model.MemberStatus]
    def disabledReason: Option[zio.aws.detective.model.MemberDisabledReason]
    def invitedTime: Option[Timestamp]
    def updatedTime: Option[Timestamp]
    def volumeUsageInBytes: Option[ByteValue]
    def volumeUsageUpdatedTime: Option[Timestamp]
    def percentOfGraphUtilization: Option[Percentage]
    def percentOfGraphUtilizationUpdatedTime: Option[Timestamp]
    def invitationType: Option[zio.aws.detective.model.InvitationType]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getGraphArn: ZIO[Any, AwsError, GraphArn] =
      AwsError.unwrapOptionField("graphArn", graphArn)
    def getMasterId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("masterId", masterId)
    def getAdministratorId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("administratorId", administratorId)
    def getStatus: ZIO[Any, AwsError, zio.aws.detective.model.MemberStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDisabledReason
        : ZIO[Any, AwsError, zio.aws.detective.model.MemberDisabledReason] =
      AwsError.unwrapOptionField("disabledReason", disabledReason)
    def getInvitedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("invitedTime", invitedTime)
    def getUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedTime", updatedTime)
    def getVolumeUsageInBytes: ZIO[Any, AwsError, ByteValue] =
      AwsError.unwrapOptionField("volumeUsageInBytes", volumeUsageInBytes)
    def getVolumeUsageUpdatedTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("volumeUsageUpdatedTime", volumeUsageUpdatedTime)
    def getPercentOfGraphUtilization: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("percentOfGraphUtilization", percentOfGraphUtilization)
    def getPercentOfGraphUtilizationUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "percentOfGraphUtilizationUpdatedTime",
        percentOfGraphUtilizationUpdatedTime
      )
    def getInvitationType
        : ZIO[Any, AwsError, zio.aws.detective.model.InvitationType] =
      AwsError.unwrapOptionField("invitationType", invitationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.MemberDetail
  ) extends zio.aws.detective.model.MemberDetail.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.detective.model.primitives.AccountId(value))
    override val emailAddress: Option[EmailAddress] = scala
      .Option(impl.emailAddress())
      .map(value => zio.aws.detective.model.primitives.EmailAddress(value))
    override val graphArn: Option[GraphArn] = scala
      .Option(impl.graphArn())
      .map(value => zio.aws.detective.model.primitives.GraphArn(value))
    override val masterId: Option[AccountId] = scala
      .Option(impl.masterId())
      .map(value => zio.aws.detective.model.primitives.AccountId(value))
    override val administratorId: Option[AccountId] = scala
      .Option(impl.administratorId())
      .map(value => zio.aws.detective.model.primitives.AccountId(value))
    override val status: Option[zio.aws.detective.model.MemberStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.detective.model.MemberStatus.wrap(value))
    override val disabledReason
        : Option[zio.aws.detective.model.MemberDisabledReason] = scala
      .Option(impl.disabledReason())
      .map(value => zio.aws.detective.model.MemberDisabledReason.wrap(value))
    override val invitedTime: Option[Timestamp] = scala
      .Option(impl.invitedTime())
      .map(value => zio.aws.detective.model.primitives.Timestamp(value))
    override val updatedTime: Option[Timestamp] = scala
      .Option(impl.updatedTime())
      .map(value => zio.aws.detective.model.primitives.Timestamp(value))
    override val volumeUsageInBytes: Option[ByteValue] = scala
      .Option(impl.volumeUsageInBytes())
      .map(value => zio.aws.detective.model.primitives.ByteValue(value))
    override val volumeUsageUpdatedTime: Option[Timestamp] = scala
      .Option(impl.volumeUsageUpdatedTime())
      .map(value => zio.aws.detective.model.primitives.Timestamp(value))
    override val percentOfGraphUtilization: Option[Percentage] = scala
      .Option(impl.percentOfGraphUtilization())
      .map(value => zio.aws.detective.model.primitives.Percentage(value))
    override val percentOfGraphUtilizationUpdatedTime: Option[Timestamp] = scala
      .Option(impl.percentOfGraphUtilizationUpdatedTime())
      .map(value => zio.aws.detective.model.primitives.Timestamp(value))
    override val invitationType
        : Option[zio.aws.detective.model.InvitationType] = scala
      .Option(impl.invitationType())
      .map(value => zio.aws.detective.model.InvitationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.MemberDetail
  ): zio.aws.detective.model.MemberDetail.ReadOnly = new Wrapper(impl)
}
