package zio.aws.detective.model
import scala.jdk.CollectionConverters.*
sealed trait MemberDisabledReason {
  def unwrap
      : software.amazon.awssdk.services.detective.model.MemberDisabledReason
}
object MemberDisabledReason {
  def wrap(
      value: software.amazon.awssdk.services.detective.model.MemberDisabledReason
  ): zio.aws.detective.model.MemberDisabledReason = value match {
    case software.amazon.awssdk.services.detective.model.MemberDisabledReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.detective.model.MemberDisabledReason.VOLUME_TOO_HIGH =>
      val r = VOLUME_TOO_HIGH
      r
    case software.amazon.awssdk.services.detective.model.MemberDisabledReason.VOLUME_UNKNOWN =>
      val r = VOLUME_UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.detective.model.MemberDisabledReason {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.MemberDisabledReason =
      software.amazon.awssdk.services.detective.model.MemberDisabledReason.UNKNOWN_TO_SDK_VERSION
  }
  case object VOLUME_TOO_HIGH
      extends zio.aws.detective.model.MemberDisabledReason {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.MemberDisabledReason =
      software.amazon.awssdk.services.detective.model.MemberDisabledReason.VOLUME_TOO_HIGH
  }
  case object VOLUME_UNKNOWN
      extends zio.aws.detective.model.MemberDisabledReason {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.MemberDisabledReason =
      software.amazon.awssdk.services.detective.model.MemberDisabledReason.VOLUME_UNKNOWN
  }
}
