package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{AccountId, GraphArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartMonitoringMemberRequest(
    graphArn: GraphArn,
    accountId: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.StartMonitoringMemberRequest = {
    import StartMonitoringMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.StartMonitoringMemberRequest
      .builder()
      .graphArn(GraphArn.unwrap(graphArn): java.lang.String)
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.StartMonitoringMemberRequest.ReadOnly =
    zio.aws.detective.model.StartMonitoringMemberRequest.wrap(buildAwsValue())
}
object StartMonitoringMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.StartMonitoringMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.StartMonitoringMemberRequest =
      zio.aws.detective.model.StartMonitoringMemberRequest(graphArn, accountId)
    def graphArn: GraphArn
    def accountId: AccountId
    def getGraphArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(graphArn)
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.StartMonitoringMemberRequest
  ) extends zio.aws.detective.model.StartMonitoringMemberRequest.ReadOnly {
    override val graphArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.graphArn())
    override val accountId: AccountId =
      zio.aws.detective.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.StartMonitoringMemberRequest
  ): zio.aws.detective.model.StartMonitoringMemberRequest.ReadOnly =
    new Wrapper(impl)
}
