package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{TagValue, TagKey, GraphArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: GraphArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.TagResourceRequest
      .builder()
      .resourceArn(GraphArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.detective.model.TagResourceRequest.ReadOnly =
    zio.aws.detective.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.TagResourceRequest =
      zio.aws.detective.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: GraphArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.TagResourceRequest
  ) extends zio.aws.detective.model.TagResourceRequest.ReadOnly {
    override val resourceArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.detective.model.primitives
          .TagKey(key) -> zio.aws.detective.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.TagResourceRequest
  ): zio.aws.detective.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
