package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{UnprocessedReason, AccountId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UnprocessedAccount(
    accountId: Option[AccountId] = None,
    reason: Option[UnprocessedReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.UnprocessedAccount = {
    import UnprocessedAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.UnprocessedAccount
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        reason.map(value => UnprocessedReason.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.UnprocessedAccount.ReadOnly =
    zio.aws.detective.model.UnprocessedAccount.wrap(buildAwsValue())
}
object UnprocessedAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.UnprocessedAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.UnprocessedAccount =
      zio.aws.detective.model.UnprocessedAccount(
        accountId.map(value => value),
        reason.map(value => value)
      )
    def accountId: Option[AccountId]
    def reason: Option[UnprocessedReason]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getReason: ZIO[Any, AwsError, UnprocessedReason] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.UnprocessedAccount
  ) extends zio.aws.detective.model.UnprocessedAccount.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.detective.model.primitives.AccountId(value))
    override val reason: Option[UnprocessedReason] = scala
      .Option(impl.reason())
      .map(value => zio.aws.detective.model.primitives.UnprocessedReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.UnprocessedAccount
  ): zio.aws.detective.model.UnprocessedAccount.ReadOnly = new Wrapper(impl)
}
