package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.GraphArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateOrganizationConfigurationRequest(
    graphArn: GraphArn,
    autoEnable: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.UpdateOrganizationConfigurationRequest = {
    import UpdateOrganizationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.UpdateOrganizationConfigurationRequest
      .builder()
      .graphArn(GraphArn.unwrap(graphArn): java.lang.String)
      .optionallyWith(autoEnable.map(value => value: java.lang.Boolean))(
        _.autoEnable
      )
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.UpdateOrganizationConfigurationRequest.ReadOnly =
    zio.aws.detective.model.UpdateOrganizationConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateOrganizationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.UpdateOrganizationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.detective.model.UpdateOrganizationConfigurationRequest =
      zio.aws.detective.model.UpdateOrganizationConfigurationRequest(
        graphArn,
        autoEnable.map(value => value)
      )
    def graphArn: GraphArn
    def autoEnable: Option[Boolean]
    def getGraphArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(graphArn)
    def getAutoEnable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoEnable", autoEnable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.UpdateOrganizationConfigurationRequest
  ) extends zio.aws.detective.model.UpdateOrganizationConfigurationRequest.ReadOnly {
    override val graphArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.graphArn())
    override val autoEnable: Option[Boolean] =
      scala.Option(impl.autoEnable()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.UpdateOrganizationConfigurationRequest
  ): zio.aws.detective.model.UpdateOrganizationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
