package zio.aws.detective
import zio.prelude.Subtype
import zio.aws.detective.model.primitives.{TagValue, TagKey, AccountId}
import java.time.Instant
import zio.aws.detective.model.primitives.TagValue.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.detective.model.primitives.AccountId.Type
    object ByteValue extends Subtype[Long]
    type ByteValue = zio.aws.detective.model.primitives.ByteValue.Type
    object EmailAddress extends Subtype[String]
    type EmailAddress = zio.aws.detective.model.primitives.EmailAddress.Type
    object EmailMessage extends Subtype[String]
    type EmailMessage = zio.aws.detective.model.primitives.EmailMessage.Type
    object GraphArn extends Subtype[String]
    type GraphArn = zio.aws.detective.model.primitives.GraphArn.Type
    object MemberResultsLimit extends Subtype[Int]
    type MemberResultsLimit =
      zio.aws.detective.model.primitives.MemberResultsLimit.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.detective.model.primitives.PaginationToken.Type
    object Percentage extends Subtype[Double]
    type Percentage = zio.aws.detective.model.primitives.Percentage.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.detective.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.detective.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.detective.model.primitives.Timestamp.Type
    object UnprocessedReason extends Subtype[String]
    type UnprocessedReason =
      zio.aws.detective.model.primitives.UnprocessedReason.Type
  }
  type AccountIdList = List[AccountId]
  type AccountList = List[zio.aws.detective.model.Account]
  type AdministratorList = List[zio.aws.detective.model.Administrator]
  type GraphList = List[zio.aws.detective.model.Graph]
  type MemberDetailList = List[zio.aws.detective.model.MemberDetail]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type UnprocessedAccountList = List[zio.aws.detective.model.UnprocessedAccount]
}
