package zio.aws.detective
import zio.aws.detective.model.ListInvitationsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.detective.{
  DetectiveAsyncClientBuilder,
  DetectiveAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.detective.model.{
  EnableOrganizationAdminAccountRequest,
  StartMonitoringMemberRequest,
  RejectInvitationRequest,
  GetMembersRequest,
  ListMembersRequest,
  ListTagsForResourceRequest,
  BatchGetGraphMemberDatasourcesRequest,
  BatchGetMembershipDatasourcesRequest,
  CreateMembersRequest,
  ListOrganizationAdminAccountsRequest,
  UpdateOrganizationConfigurationRequest,
  DeleteGraphRequest,
  ListInvitationsRequest,
  DisassociateMembershipRequest,
  UntagResourceRequest,
  CreateGraphRequest,
  AcceptInvitationRequest,
  ListGraphsRequest,
  DeleteMembersRequest,
  ListDatasourcePackagesRequest,
  DescribeOrganizationConfigurationRequest,
  DatasourcePackage,
  TagResourceRequest,
  UpdateDatasourcePackagesRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.detective.model.{
  UpdateDatasourcePackagesResponse,
  DisableOrganizationAdminAccountRequest,
  BatchGetMembershipDatasourcesResponse,
  ListOrganizationAdminAccountsResponse,
  ListMembersResponse,
  Administrator,
  ListDatasourcePackagesResponse,
  DescribeOrganizationConfigurationResponse,
  DisableOrganizationAdminAccountResponse,
  CreateGraphResponse,
  ListTagsForResourceResponse,
  StartMonitoringMemberResponse,
  UntagResourceResponse,
  AcceptInvitationResponse,
  DeleteMembersResponse,
  CreateMembersResponse,
  MemberDetail,
  UpdateOrganizationConfigurationResponse,
  GetMembersResponse,
  DatasourcePackageIngestDetail,
  ListInvitationsResponse,
  Graph,
  BatchGetGraphMemberDatasourcesResponse,
  RejectInvitationResponse,
  EnableOrganizationAdminAccountResponse,
  TagResourceResponse,
  DisassociateMembershipResponse,
  ListGraphsResponse,
  DeleteGraphResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Detective extends AspectSupport[Detective] {
  val api: DetectiveAsyncClient
  def disableOrganizationAdminAccount(): IO[AwsError, Unit]
  def listOrganizationAdminAccounts(
      request: ListOrganizationAdminAccountsRequest
  ): ZStream[Any, AwsError, zio.aws.detective.model.Administrator.ReadOnly]
  def listOrganizationAdminAccountsPaginated(
      request: ListOrganizationAdminAccountsRequest
  ): IO[
    AwsError,
    zio.aws.detective.model.ListOrganizationAdminAccountsResponse.ReadOnly
  ]
  def updateOrganizationConfiguration(
      request: UpdateOrganizationConfigurationRequest
  ): IO[AwsError, Unit]
  def listMembers(
      request: ListMembersRequest
  ): ZStream[Any, AwsError, zio.aws.detective.model.MemberDetail.ReadOnly]
  def listMembersPaginated(
      request: ListMembersRequest
  ): IO[AwsError, zio.aws.detective.model.ListMembersResponse.ReadOnly]
  def startMonitoringMember(
      request: StartMonitoringMemberRequest
  ): IO[AwsError, Unit]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.detective.model.UntagResourceResponse.ReadOnly]
  def createMembers(
      request: CreateMembersRequest
  ): IO[AwsError, zio.aws.detective.model.CreateMembersResponse.ReadOnly]
  def describeOrganizationConfiguration(
      request: DescribeOrganizationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.detective.model.DescribeOrganizationConfigurationResponse.ReadOnly
  ]
  def acceptInvitation(request: AcceptInvitationRequest): IO[AwsError, Unit]
  def listGraphs(
      request: ListGraphsRequest
  ): ZStream[Any, AwsError, zio.aws.detective.model.Graph.ReadOnly]
  def listGraphsPaginated(
      request: ListGraphsRequest
  ): IO[AwsError, zio.aws.detective.model.ListGraphsResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.detective.model.ListTagsForResourceResponse.ReadOnly]
  def updateDatasourcePackages(
      request: UpdateDatasourcePackagesRequest
  ): IO[AwsError, Unit]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.detective.model.TagResourceResponse.ReadOnly]
  def listInvitations(
      request: ListInvitationsRequest
  ): ZStream[Any, AwsError, zio.aws.detective.model.MemberDetail.ReadOnly]
  def listInvitationsPaginated(
      request: ListInvitationsRequest
  ): IO[AwsError, ReadOnly]
  def listDatasourcePackages(
      request: ListDatasourcePackagesRequest
  ): ZStream[Any, AwsError, Tuple2[
    DatasourcePackage,
    zio.aws.detective.model.DatasourcePackageIngestDetail.ReadOnly
  ]]
  def listDatasourcePackagesPaginated(
      request: ListDatasourcePackagesRequest
  ): IO[
    AwsError,
    zio.aws.detective.model.ListDatasourcePackagesResponse.ReadOnly
  ]
  def deleteGraph(request: DeleteGraphRequest): IO[AwsError, Unit]
  def batchGetMembershipDatasources(
      request: BatchGetMembershipDatasourcesRequest
  ): IO[
    AwsError,
    zio.aws.detective.model.BatchGetMembershipDatasourcesResponse.ReadOnly
  ]
  def enableOrganizationAdminAccount(
      request: EnableOrganizationAdminAccountRequest
  ): IO[AwsError, Unit]
  def disassociateMembership(
      request: DisassociateMembershipRequest
  ): IO[AwsError, Unit]
  def batchGetGraphMemberDatasources(
      request: BatchGetGraphMemberDatasourcesRequest
  ): IO[
    AwsError,
    zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse.ReadOnly
  ]
  def createGraph(
      request: CreateGraphRequest
  ): IO[AwsError, zio.aws.detective.model.CreateGraphResponse.ReadOnly]
  def rejectInvitation(request: RejectInvitationRequest): IO[AwsError, Unit]
  def deleteMembers(
      request: DeleteMembersRequest
  ): IO[AwsError, zio.aws.detective.model.DeleteMembersResponse.ReadOnly]
  def getMembers(
      request: GetMembersRequest
  ): IO[AwsError, zio.aws.detective.model.GetMembersResponse.ReadOnly]
}
object Detective {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Detective] = customized(
    identity
  )
  def customized(
      customization: DetectiveAsyncClientBuilder => DetectiveAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Detective] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DetectiveAsyncClientBuilder => DetectiveAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Detective] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DetectiveAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[DetectiveAsyncClient, DetectiveAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[DetectiveAsyncClient, DetectiveAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new DetectiveImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class DetectiveImpl[R](
      override val api: DetectiveAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Detective
      with AwsServiceBase[R] {
    override val serviceName: String = "Detective"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DetectiveImpl[R1] = new DetectiveImpl(api, newAspect, r)
    def disableOrganizationAdminAccount(): IO[AwsError, Unit] =
      asyncRequestResponse[
        DisableOrganizationAdminAccountRequest,
        DisableOrganizationAdminAccountResponse
      ]("disableOrganizationAdminAccount", api.disableOrganizationAdminAccount)(
        DisableOrganizationAdminAccountRequest.builder().build()
      ).unit.provideEnvironment(r)
    def listOrganizationAdminAccounts(
        request: ListOrganizationAdminAccountsRequest
    ): ZStream[Any, AwsError, zio.aws.detective.model.Administrator.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.detective.model.ListOrganizationAdminAccountsRequest,
        ListOrganizationAdminAccountsResponse,
        Administrator
      ](
        "listOrganizationAdminAccounts",
        api.listOrganizationAdminAccounts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.administrators().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.detective.model.Administrator.wrap(item))
        .provideEnvironment(r)
    def listOrganizationAdminAccountsPaginated(
        request: ListOrganizationAdminAccountsRequest
    ): IO[
      AwsError,
      zio.aws.detective.model.ListOrganizationAdminAccountsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.ListOrganizationAdminAccountsRequest,
      ListOrganizationAdminAccountsResponse
    ]("listOrganizationAdminAccounts", api.listOrganizationAdminAccounts)(
      request.buildAwsValue()
    ).map(zio.aws.detective.model.ListOrganizationAdminAccountsResponse.wrap)
      .provideEnvironment(r)
    def updateOrganizationConfiguration(
        request: UpdateOrganizationConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.UpdateOrganizationConfigurationRequest,
      UpdateOrganizationConfigurationResponse
    ]("updateOrganizationConfiguration", api.updateOrganizationConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listMembers(
        request: ListMembersRequest
    ): ZStream[Any, AwsError, zio.aws.detective.model.MemberDetail.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.detective.model.ListMembersRequest,
        ListMembersResponse,
        MemberDetail
      ](
        "listMembers",
        api.listMembers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.memberDetails().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.detective.model.MemberDetail.wrap(item))
        .provideEnvironment(r)
    def listMembersPaginated(
        request: ListMembersRequest
    ): IO[AwsError, zio.aws.detective.model.ListMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.detective.model.ListMembersRequest,
        ListMembersResponse
      ]("listMembers", api.listMembers)(request.buildAwsValue())
        .map(zio.aws.detective.model.ListMembersResponse.wrap)
        .provideEnvironment(r)
    def startMonitoringMember(
        request: StartMonitoringMemberRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.StartMonitoringMemberRequest,
      StartMonitoringMemberResponse
    ]("startMonitoringMember", api.startMonitoringMember)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.detective.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.detective.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.detective.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createMembers(
        request: CreateMembersRequest
    ): IO[AwsError, zio.aws.detective.model.CreateMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.detective.model.CreateMembersRequest,
        CreateMembersResponse
      ]("createMembers", api.createMembers)(request.buildAwsValue())
        .map(zio.aws.detective.model.CreateMembersResponse.wrap)
        .provideEnvironment(r)
    def describeOrganizationConfiguration(
        request: DescribeOrganizationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.detective.model.DescribeOrganizationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.DescribeOrganizationConfigurationRequest,
      DescribeOrganizationConfigurationResponse
    ](
      "describeOrganizationConfiguration",
      api.describeOrganizationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.detective.model.DescribeOrganizationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def acceptInvitation(request: AcceptInvitationRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.detective.model.AcceptInvitationRequest,
        AcceptInvitationResponse
      ]("acceptInvitation", api.acceptInvitation)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listGraphs(
        request: ListGraphsRequest
    ): ZStream[Any, AwsError, zio.aws.detective.model.Graph.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.detective.model.ListGraphsRequest,
        ListGraphsResponse,
        Graph
      ](
        "listGraphs",
        api.listGraphs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.graphList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.detective.model.Graph.wrap(item))
        .provideEnvironment(r)
    def listGraphsPaginated(
        request: ListGraphsRequest
    ): IO[AwsError, zio.aws.detective.model.ListGraphsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.detective.model.ListGraphsRequest,
        ListGraphsResponse
      ]("listGraphs", api.listGraphs)(request.buildAwsValue())
        .map(zio.aws.detective.model.ListGraphsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.detective.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.detective.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def updateDatasourcePackages(
        request: UpdateDatasourcePackagesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.UpdateDatasourcePackagesRequest,
      UpdateDatasourcePackagesResponse
    ]("updateDatasourcePackages", api.updateDatasourcePackages)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.detective.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.detective.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.detective.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listInvitations(
        request: ListInvitationsRequest
    ): ZStream[Any, AwsError, zio.aws.detective.model.MemberDetail.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.detective.model.ListInvitationsRequest,
        ListInvitationsResponse,
        MemberDetail
      ](
        "listInvitations",
        api.listInvitations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.invitations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.detective.model.MemberDetail.wrap(item))
        .provideEnvironment(r)
    def listInvitationsPaginated(
        request: ListInvitationsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.ListInvitationsRequest,
      ListInvitationsResponse
    ]("listInvitations", api.listInvitations)(request.buildAwsValue())
      .map(zio.aws.detective.model.ListInvitationsResponse.wrap)
      .provideEnvironment(r)
    def listDatasourcePackages(
        request: ListDatasourcePackagesRequest
    ): ZStream[Any, AwsError, Tuple2[
      DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageIngestDetail.ReadOnly
    ]] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.detective.model.ListDatasourcePackagesRequest,
      ListDatasourcePackagesResponse,
      (
          software.amazon.awssdk.services.detective.model.DatasourcePackage,
          DatasourcePackageIngestDetail
      )
    ](
      "listDatasourcePackages",
      api.listDatasourcePackages,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.datasourcePackages().asScala)
    )(request.buildAwsValue())
      .map({ case (key, value) =>
        DatasourcePackage.wrap(
          key
        ) -> zio.aws.detective.model.DatasourcePackageIngestDetail.wrap(value)
      })
      .provideEnvironment(r)
    def listDatasourcePackagesPaginated(
        request: ListDatasourcePackagesRequest
    ): IO[
      AwsError,
      zio.aws.detective.model.ListDatasourcePackagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.ListDatasourcePackagesRequest,
      ListDatasourcePackagesResponse
    ]("listDatasourcePackages", api.listDatasourcePackages)(
      request.buildAwsValue()
    ).map(zio.aws.detective.model.ListDatasourcePackagesResponse.wrap)
      .provideEnvironment(r)
    def deleteGraph(request: DeleteGraphRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.detective.model.DeleteGraphRequest,
        DeleteGraphResponse
      ]("deleteGraph", api.deleteGraph)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def batchGetMembershipDatasources(
        request: BatchGetMembershipDatasourcesRequest
    ): IO[
      AwsError,
      zio.aws.detective.model.BatchGetMembershipDatasourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesRequest,
      BatchGetMembershipDatasourcesResponse
    ]("batchGetMembershipDatasources", api.batchGetMembershipDatasources)(
      request.buildAwsValue()
    ).map(zio.aws.detective.model.BatchGetMembershipDatasourcesResponse.wrap)
      .provideEnvironment(r)
    def enableOrganizationAdminAccount(
        request: EnableOrganizationAdminAccountRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.EnableOrganizationAdminAccountRequest,
      EnableOrganizationAdminAccountResponse
    ]("enableOrganizationAdminAccount", api.enableOrganizationAdminAccount)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def disassociateMembership(
        request: DisassociateMembershipRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.DisassociateMembershipRequest,
      DisassociateMembershipResponse
    ]("disassociateMembership", api.disassociateMembership)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def batchGetGraphMemberDatasources(
        request: BatchGetGraphMemberDatasourcesRequest
    ): IO[
      AwsError,
      zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesRequest,
      BatchGetGraphMemberDatasourcesResponse
    ]("batchGetGraphMemberDatasources", api.batchGetGraphMemberDatasources)(
      request.buildAwsValue()
    ).map(zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse.wrap)
      .provideEnvironment(r)
    def createGraph(
        request: CreateGraphRequest
    ): IO[AwsError, zio.aws.detective.model.CreateGraphResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.detective.model.CreateGraphRequest,
        CreateGraphResponse
      ]("createGraph", api.createGraph)(request.buildAwsValue())
        .map(zio.aws.detective.model.CreateGraphResponse.wrap)
        .provideEnvironment(r)
    def rejectInvitation(request: RejectInvitationRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.detective.model.RejectInvitationRequest,
        RejectInvitationResponse
      ]("rejectInvitation", api.rejectInvitation)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteMembers(
        request: DeleteMembersRequest
    ): IO[AwsError, zio.aws.detective.model.DeleteMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.detective.model.DeleteMembersRequest,
        DeleteMembersResponse
      ]("deleteMembers", api.deleteMembers)(request.buildAwsValue())
        .map(zio.aws.detective.model.DeleteMembersResponse.wrap)
        .provideEnvironment(r)
    def getMembers(
        request: GetMembersRequest
    ): IO[AwsError, zio.aws.detective.model.GetMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.detective.model.GetMembersRequest,
        GetMembersResponse
      ]("getMembers", api.getMembers)(request.buildAwsValue())
        .map(zio.aws.detective.model.GetMembersResponse.wrap)
        .provideEnvironment(r)
  }
  def disableOrganizationAdminAccount()
      : ZIO[zio.aws.detective.Detective, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disableOrganizationAdminAccount())
  def listOrganizationAdminAccounts(
      request: ListOrganizationAdminAccountsRequest
  ): ZStream[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.Administrator.ReadOnly
  ] = ZStream.serviceWithStream(_.listOrganizationAdminAccounts(request))
  def listOrganizationAdminAccountsPaginated(
      request: ListOrganizationAdminAccountsRequest
  ): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.ListOrganizationAdminAccountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOrganizationAdminAccountsPaginated(request))
  def updateOrganizationConfiguration(
      request: UpdateOrganizationConfigurationRequest
  ): ZIO[zio.aws.detective.Detective, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateOrganizationConfiguration(request))
  def listMembers(request: ListMembersRequest): ZStream[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.MemberDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.listMembers(request))
  def listMembersPaginated(request: ListMembersRequest): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.ListMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMembersPaginated(request))
  def startMonitoringMember(
      request: StartMonitoringMemberRequest
  ): ZIO[zio.aws.detective.Detective, AwsError, Unit] =
    ZIO.serviceWithZIO(_.startMonitoringMember(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createMembers(request: CreateMembersRequest): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.CreateMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMembers(request))
  def describeOrganizationConfiguration(
      request: DescribeOrganizationConfigurationRequest
  ): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.DescribeOrganizationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrganizationConfiguration(request))
  def acceptInvitation(
      request: AcceptInvitationRequest
  ): ZIO[zio.aws.detective.Detective, AwsError, Unit] =
    ZIO.serviceWithZIO(_.acceptInvitation(request))
  def listGraphs(request: ListGraphsRequest): ZStream[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.Graph.ReadOnly
  ] = ZStream.serviceWithStream(_.listGraphs(request))
  def listGraphsPaginated(request: ListGraphsRequest): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.ListGraphsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGraphsPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def updateDatasourcePackages(
      request: UpdateDatasourcePackagesRequest
  ): ZIO[zio.aws.detective.Detective, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateDatasourcePackages(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listInvitations(request: ListInvitationsRequest): ZStream[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.MemberDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.listInvitations(request))
  def listInvitationsPaginated(
      request: ListInvitationsRequest
  ): ZIO[zio.aws.detective.Detective, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listInvitationsPaginated(request))
  def listDatasourcePackages(
      request: ListDatasourcePackagesRequest
  ): ZStream[zio.aws.detective.Detective, AwsError, Tuple2[
    DatasourcePackage,
    zio.aws.detective.model.DatasourcePackageIngestDetail.ReadOnly
  ]] = ZStream.serviceWithStream(_.listDatasourcePackages(request))
  def listDatasourcePackagesPaginated(
      request: ListDatasourcePackagesRequest
  ): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.ListDatasourcePackagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasourcePackagesPaginated(request))
  def deleteGraph(
      request: DeleteGraphRequest
  ): ZIO[zio.aws.detective.Detective, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteGraph(request))
  def batchGetMembershipDatasources(
      request: BatchGetMembershipDatasourcesRequest
  ): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.BatchGetMembershipDatasourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetMembershipDatasources(request))
  def enableOrganizationAdminAccount(
      request: EnableOrganizationAdminAccountRequest
  ): ZIO[zio.aws.detective.Detective, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableOrganizationAdminAccount(request))
  def disassociateMembership(
      request: DisassociateMembershipRequest
  ): ZIO[zio.aws.detective.Detective, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateMembership(request))
  def batchGetGraphMemberDatasources(
      request: BatchGetGraphMemberDatasourcesRequest
  ): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetGraphMemberDatasources(request))
  def createGraph(request: CreateGraphRequest): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.CreateGraphResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGraph(request))
  def rejectInvitation(
      request: RejectInvitationRequest
  ): ZIO[zio.aws.detective.Detective, AwsError, Unit] =
    ZIO.serviceWithZIO(_.rejectInvitation(request))
  def deleteMembers(request: DeleteMembersRequest): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.DeleteMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMembers(request))
  def getMembers(request: GetMembersRequest): ZIO[
    zio.aws.detective.Detective,
    AwsError,
    zio.aws.detective.model.GetMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMembers(request))
}
