package zio.aws.detective
import zio.aws.detective.model.ListInvitationsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.detective.DetectiveAsyncClient
import zio.aws.core.AwsError
import zio.aws.detective.model.{
  EnableOrganizationAdminAccountRequest,
  StartMonitoringMemberRequest,
  RejectInvitationRequest,
  GetMembersRequest,
  ListMembersRequest,
  ListTagsForResourceRequest,
  BatchGetGraphMemberDatasourcesRequest,
  BatchGetMembershipDatasourcesRequest,
  CreateMembersRequest,
  ListOrganizationAdminAccountsRequest,
  UpdateOrganizationConfigurationRequest,
  DeleteGraphRequest,
  ListInvitationsRequest,
  DisassociateMembershipRequest,
  UntagResourceRequest,
  CreateGraphRequest,
  AcceptInvitationRequest,
  ListGraphsRequest,
  DeleteMembersRequest,
  ListDatasourcePackagesRequest,
  DescribeOrganizationConfigurationRequest,
  DatasourcePackage,
  TagResourceRequest,
  UpdateDatasourcePackagesRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object DetectiveMock extends Mock[Detective] {
  object DisableOrganizationAdminAccount extends Effect[Unit, AwsError, Unit]
  object ListOrganizationAdminAccounts
      extends Stream[
        ListOrganizationAdminAccountsRequest,
        AwsError,
        zio.aws.detective.model.Administrator.ReadOnly
      ]
  object ListOrganizationAdminAccountsPaginated
      extends Effect[
        ListOrganizationAdminAccountsRequest,
        AwsError,
        zio.aws.detective.model.ListOrganizationAdminAccountsResponse.ReadOnly
      ]
  object UpdateOrganizationConfiguration
      extends Effect[UpdateOrganizationConfigurationRequest, AwsError, Unit]
  object ListMembers
      extends Stream[
        ListMembersRequest,
        AwsError,
        zio.aws.detective.model.MemberDetail.ReadOnly
      ]
  object ListMembersPaginated
      extends Effect[
        ListMembersRequest,
        AwsError,
        zio.aws.detective.model.ListMembersResponse.ReadOnly
      ]
  object StartMonitoringMember
      extends Effect[StartMonitoringMemberRequest, AwsError, Unit]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.detective.model.UntagResourceResponse.ReadOnly
      ]
  object CreateMembers
      extends Effect[
        CreateMembersRequest,
        AwsError,
        zio.aws.detective.model.CreateMembersResponse.ReadOnly
      ]
  object DescribeOrganizationConfiguration
      extends Effect[
        DescribeOrganizationConfigurationRequest,
        AwsError,
        zio.aws.detective.model.DescribeOrganizationConfigurationResponse.ReadOnly
      ]
  object AcceptInvitation
      extends Effect[AcceptInvitationRequest, AwsError, Unit]
  object ListGraphs
      extends Stream[
        ListGraphsRequest,
        AwsError,
        zio.aws.detective.model.Graph.ReadOnly
      ]
  object ListGraphsPaginated
      extends Effect[
        ListGraphsRequest,
        AwsError,
        zio.aws.detective.model.ListGraphsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.detective.model.ListTagsForResourceResponse.ReadOnly
      ]
  object UpdateDatasourcePackages
      extends Effect[UpdateDatasourcePackagesRequest, AwsError, Unit]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.detective.model.TagResourceResponse.ReadOnly
      ]
  object ListInvitations
      extends Stream[
        ListInvitationsRequest,
        AwsError,
        zio.aws.detective.model.MemberDetail.ReadOnly
      ]
  object ListInvitationsPaginated
      extends Effect[ListInvitationsRequest, AwsError, ReadOnly]
  object ListDatasourcePackages
      extends Stream[ListDatasourcePackagesRequest, AwsError, Tuple2[
        DatasourcePackage,
        zio.aws.detective.model.DatasourcePackageIngestDetail.ReadOnly
      ]]
  object ListDatasourcePackagesPaginated
      extends Effect[
        ListDatasourcePackagesRequest,
        AwsError,
        zio.aws.detective.model.ListDatasourcePackagesResponse.ReadOnly
      ]
  object DeleteGraph extends Effect[DeleteGraphRequest, AwsError, Unit]
  object BatchGetMembershipDatasources
      extends Effect[
        BatchGetMembershipDatasourcesRequest,
        AwsError,
        zio.aws.detective.model.BatchGetMembershipDatasourcesResponse.ReadOnly
      ]
  object EnableOrganizationAdminAccount
      extends Effect[EnableOrganizationAdminAccountRequest, AwsError, Unit]
  object DisassociateMembership
      extends Effect[DisassociateMembershipRequest, AwsError, Unit]
  object BatchGetGraphMemberDatasources
      extends Effect[
        BatchGetGraphMemberDatasourcesRequest,
        AwsError,
        zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse.ReadOnly
      ]
  object CreateGraph
      extends Effect[
        CreateGraphRequest,
        AwsError,
        zio.aws.detective.model.CreateGraphResponse.ReadOnly
      ]
  object RejectInvitation
      extends Effect[RejectInvitationRequest, AwsError, Unit]
  object DeleteMembers
      extends Effect[
        DeleteMembersRequest,
        AwsError,
        zio.aws.detective.model.DeleteMembersResponse.ReadOnly
      ]
  object GetMembers
      extends Effect[
        GetMembersRequest,
        AwsError,
        zio.aws.detective.model.GetMembersResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Detective] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Detective] { rts =>
        zio.ZIO.succeed {
          new Detective {
            val api: DetectiveAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Detective = this
            def disableOrganizationAdminAccount(): IO[AwsError, Unit] =
              proxy(DisableOrganizationAdminAccount)
            def listOrganizationAdminAccounts(
                request: ListOrganizationAdminAccountsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.detective.model.Administrator.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListOrganizationAdminAccounts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listOrganizationAdminAccountsPaginated(
                request: ListOrganizationAdminAccountsRequest
            ): IO[
              AwsError,
              zio.aws.detective.model.ListOrganizationAdminAccountsResponse.ReadOnly
            ] = proxy(ListOrganizationAdminAccountsPaginated, request)
            def updateOrganizationConfiguration(
                request: UpdateOrganizationConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(UpdateOrganizationConfiguration, request)
            def listMembers(request: ListMembersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.detective.model.MemberDetail.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMembers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMembersPaginated(request: ListMembersRequest): IO[
              AwsError,
              zio.aws.detective.model.ListMembersResponse.ReadOnly
            ] = proxy(ListMembersPaginated, request)
            def startMonitoringMember(
                request: StartMonitoringMemberRequest
            ): IO[AwsError, Unit] = proxy(StartMonitoringMember, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.detective.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createMembers(request: CreateMembersRequest): IO[
              AwsError,
              zio.aws.detective.model.CreateMembersResponse.ReadOnly
            ] = proxy(CreateMembers, request)
            def describeOrganizationConfiguration(
                request: DescribeOrganizationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.detective.model.DescribeOrganizationConfigurationResponse.ReadOnly
            ] = proxy(DescribeOrganizationConfiguration, request)
            def acceptInvitation(
                request: AcceptInvitationRequest
            ): IO[AwsError, Unit] = proxy(AcceptInvitation, request)
            def listGraphs(
                request: ListGraphsRequest
            ): ZStream[Any, AwsError, zio.aws.detective.model.Graph.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListGraphs, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listGraphsPaginated(request: ListGraphsRequest): IO[
              AwsError,
              zio.aws.detective.model.ListGraphsResponse.ReadOnly
            ] = proxy(ListGraphsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.detective.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def updateDatasourcePackages(
                request: UpdateDatasourcePackagesRequest
            ): IO[AwsError, Unit] = proxy(UpdateDatasourcePackages, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.detective.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listInvitations(request: ListInvitationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.detective.model.MemberDetail.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInvitations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInvitationsPaginated(
                request: ListInvitationsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListInvitationsPaginated, request)
            def listDatasourcePackages(
                request: ListDatasourcePackagesRequest
            ): ZStream[Any, AwsError, Tuple2[
              DatasourcePackage,
              zio.aws.detective.model.DatasourcePackageIngestDetail.ReadOnly
            ]] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDatasourcePackages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDatasourcePackagesPaginated(
                request: ListDatasourcePackagesRequest
            ): IO[
              AwsError,
              zio.aws.detective.model.ListDatasourcePackagesResponse.ReadOnly
            ] = proxy(ListDatasourcePackagesPaginated, request)
            def deleteGraph(request: DeleteGraphRequest): IO[AwsError, Unit] =
              proxy(DeleteGraph, request)
            def batchGetMembershipDatasources(
                request: BatchGetMembershipDatasourcesRequest
            ): IO[
              AwsError,
              zio.aws.detective.model.BatchGetMembershipDatasourcesResponse.ReadOnly
            ] = proxy(BatchGetMembershipDatasources, request)
            def enableOrganizationAdminAccount(
                request: EnableOrganizationAdminAccountRequest
            ): IO[AwsError, Unit] =
              proxy(EnableOrganizationAdminAccount, request)
            def disassociateMembership(
                request: DisassociateMembershipRequest
            ): IO[AwsError, Unit] = proxy(DisassociateMembership, request)
            def batchGetGraphMemberDatasources(
                request: BatchGetGraphMemberDatasourcesRequest
            ): IO[
              AwsError,
              zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse.ReadOnly
            ] = proxy(BatchGetGraphMemberDatasources, request)
            def createGraph(request: CreateGraphRequest): IO[
              AwsError,
              zio.aws.detective.model.CreateGraphResponse.ReadOnly
            ] = proxy(CreateGraph, request)
            def rejectInvitation(
                request: RejectInvitationRequest
            ): IO[AwsError, Unit] = proxy(RejectInvitation, request)
            def deleteMembers(request: DeleteMembersRequest): IO[
              AwsError,
              zio.aws.detective.model.DeleteMembersResponse.ReadOnly
            ] = proxy(DeleteMembers, request)
            def getMembers(request: GetMembersRequest): IO[
              AwsError,
              zio.aws.detective.model.GetMembersResponse.ReadOnly
            ] = proxy(GetMembers, request)
          }
        }
      }
    }
  }
}
