package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.GraphArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AcceptInvitationRequest(graphArn: GraphArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.AcceptInvitationRequest = {
    import AcceptInvitationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.AcceptInvitationRequest
      .builder()
      .graphArn(GraphArn.unwrap(graphArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.AcceptInvitationRequest.ReadOnly =
    zio.aws.detective.model.AcceptInvitationRequest.wrap(buildAwsValue())
}
object AcceptInvitationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.AcceptInvitationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.AcceptInvitationRequest =
      zio.aws.detective.model.AcceptInvitationRequest(graphArn)
    def graphArn: GraphArn
    def getGraphArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(graphArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.AcceptInvitationRequest
  ) extends zio.aws.detective.model.AcceptInvitationRequest.ReadOnly {
    override val graphArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.graphArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.AcceptInvitationRequest
  ): zio.aws.detective.model.AcceptInvitationRequest.ReadOnly = new Wrapper(
    impl
  )
}
