package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{EmailAddress, AccountId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Account(accountId: AccountId, emailAddress: EmailAddress) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.Account = {
    import Account.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.Account
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .emailAddress(EmailAddress.unwrap(emailAddress): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.Account.ReadOnly =
    zio.aws.detective.model.Account.wrap(buildAwsValue())
}
object Account {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.detective.model.Account] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.Account =
      zio.aws.detective.model.Account(accountId, emailAddress)
    def accountId: AccountId
    def emailAddress: EmailAddress
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(emailAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.Account
  ) extends zio.aws.detective.model.Account.ReadOnly {
    override val accountId: AccountId =
      zio.aws.detective.model.primitives.AccountId(impl.accountId())
    override val emailAddress: EmailAddress =
      zio.aws.detective.model.primitives.EmailAddress(impl.emailAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.Account
  ): zio.aws.detective.model.Account.ReadOnly = new Wrapper(impl)
}
