package zio.aws.detective.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.detective.model.primitives.{Timestamp, GraphArn, AccountId}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Administrator(
    accountId: Optional[AccountId] = Optional.Absent,
    graphArn: Optional[GraphArn] = Optional.Absent,
    delegationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.Administrator = {
    import Administrator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.Administrator
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        graphArn.map(value => GraphArn.unwrap(value): java.lang.String)
      )(_.graphArn)
      .optionallyWith(
        delegationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.delegationTime)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.Administrator.ReadOnly =
    zio.aws.detective.model.Administrator.wrap(buildAwsValue())
}
object Administrator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.Administrator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.Administrator =
      zio.aws.detective.model.Administrator(
        accountId.map(value => value),
        graphArn.map(value => value),
        delegationTime.map(value => value)
      )
    def accountId: Optional[AccountId]
    def graphArn: Optional[GraphArn]
    def delegationTime: Optional[Timestamp]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getGraphArn: ZIO[Any, AwsError, GraphArn] =
      AwsError.unwrapOptionField("graphArn", graphArn)
    def getDelegationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("delegationTime", delegationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.Administrator
  ) extends zio.aws.detective.model.Administrator.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.detective.model.primitives.AccountId(value))
    override val graphArn: Optional[GraphArn] = zio.aws.core.internal
      .optionalFromNullable(impl.graphArn())
      .map(value => zio.aws.detective.model.primitives.GraphArn(value))
    override val delegationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.delegationTime())
      .map(value => zio.aws.detective.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.Administrator
  ): zio.aws.detective.model.Administrator.ReadOnly = new Wrapper(impl)
}
