package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{AccountId, GraphArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetGraphMemberDatasourcesRequest(
    graphArn: GraphArn,
    accountIds: Iterable[AccountId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesRequest = {
    import BatchGetGraphMemberDatasourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesRequest
      .builder()
      .graphArn(GraphArn.unwrap(graphArn): java.lang.String)
      .accountIds(accountIds.map { item =>
        AccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.BatchGetGraphMemberDatasourcesRequest.ReadOnly =
    zio.aws.detective.model.BatchGetGraphMemberDatasourcesRequest
      .wrap(buildAwsValue())
}
object BatchGetGraphMemberDatasourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.detective.model.BatchGetGraphMemberDatasourcesRequest =
      zio.aws.detective.model
        .BatchGetGraphMemberDatasourcesRequest(graphArn, accountIds)
    def graphArn: GraphArn
    def accountIds: List[AccountId]
    def getGraphArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(graphArn)
    def getAccountIds: ZIO[Any, Nothing, List[AccountId]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesRequest
  ) extends zio.aws.detective.model.BatchGetGraphMemberDatasourcesRequest.ReadOnly {
    override val graphArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.graphArn())
    override val accountIds: List[AccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.detective.model.primitives.AccountId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesRequest
  ): zio.aws.detective.model.BatchGetGraphMemberDatasourcesRequest.ReadOnly =
    new Wrapper(impl)
}
