package zio.aws.detective.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetGraphMemberDatasourcesResponse(
    memberDatasources: Optional[
      Iterable[zio.aws.detective.model.MembershipDatasources]
    ] = Optional.Absent,
    unprocessedAccounts: Optional[
      Iterable[zio.aws.detective.model.UnprocessedAccount]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesResponse = {
    import BatchGetGraphMemberDatasourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesResponse
      .builder()
      .optionallyWith(
        memberDatasources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memberDatasources)
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse.ReadOnly =
    zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse
      .wrap(buildAwsValue())
}
object BatchGetGraphMemberDatasourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse =
      zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse(
        memberDatasources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def memberDatasources
        : Optional[List[zio.aws.detective.model.MembershipDatasources.ReadOnly]]
    def unprocessedAccounts
        : Optional[List[zio.aws.detective.model.UnprocessedAccount.ReadOnly]]
    def getMemberDatasources: ZIO[Any, AwsError, List[
      zio.aws.detective.model.MembershipDatasources.ReadOnly
    ]] = AwsError.unwrapOptionField("memberDatasources", memberDatasources)
    def getUnprocessedAccounts: ZIO[Any, AwsError, List[
      zio.aws.detective.model.UnprocessedAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesResponse
  ) extends zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse.ReadOnly {
    override val memberDatasources: Optional[
      List[zio.aws.detective.model.MembershipDatasources.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.memberDatasources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.detective.model.MembershipDatasources.wrap(item)
        }.toList
      )
    override val unprocessedAccounts
        : Optional[List[zio.aws.detective.model.UnprocessedAccount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.detective.model.UnprocessedAccount.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.BatchGetGraphMemberDatasourcesResponse
  ): zio.aws.detective.model.BatchGetGraphMemberDatasourcesResponse.ReadOnly =
    new Wrapper(impl)
}
