package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.GraphArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetMembershipDatasourcesRequest(
    graphArns: Iterable[GraphArn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesRequest = {
    import BatchGetMembershipDatasourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesRequest
      .builder()
      .graphArns(graphArns.map { item =>
        GraphArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.BatchGetMembershipDatasourcesRequest.ReadOnly =
    zio.aws.detective.model.BatchGetMembershipDatasourcesRequest
      .wrap(buildAwsValue())
}
object BatchGetMembershipDatasourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.detective.model.BatchGetMembershipDatasourcesRequest =
      zio.aws.detective.model.BatchGetMembershipDatasourcesRequest(graphArns)
    def graphArns: List[GraphArn]
    def getGraphArns: ZIO[Any, Nothing, List[GraphArn]] = ZIO.succeed(graphArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesRequest
  ) extends zio.aws.detective.model.BatchGetMembershipDatasourcesRequest.ReadOnly {
    override val graphArns: List[GraphArn] = impl
      .graphArns()
      .asScala
      .map { item =>
        zio.aws.detective.model.primitives.GraphArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesRequest
  ): zio.aws.detective.model.BatchGetMembershipDatasourcesRequest.ReadOnly =
    new Wrapper(impl)
}
