package zio.aws.detective.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetMembershipDatasourcesResponse(
    membershipDatasources: Optional[
      Iterable[zio.aws.detective.model.MembershipDatasources]
    ] = Optional.Absent,
    unprocessedGraphs: Optional[
      Iterable[zio.aws.detective.model.UnprocessedGraph]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesResponse = {
    import BatchGetMembershipDatasourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesResponse
      .builder()
      .optionallyWith(
        membershipDatasources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.membershipDatasources)
      .optionallyWith(
        unprocessedGraphs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedGraphs)
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.BatchGetMembershipDatasourcesResponse.ReadOnly =
    zio.aws.detective.model.BatchGetMembershipDatasourcesResponse
      .wrap(buildAwsValue())
}
object BatchGetMembershipDatasourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.detective.model.BatchGetMembershipDatasourcesResponse =
      zio.aws.detective.model.BatchGetMembershipDatasourcesResponse(
        membershipDatasources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedGraphs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def membershipDatasources
        : Optional[List[zio.aws.detective.model.MembershipDatasources.ReadOnly]]
    def unprocessedGraphs
        : Optional[List[zio.aws.detective.model.UnprocessedGraph.ReadOnly]]
    def getMembershipDatasources: ZIO[Any, AwsError, List[
      zio.aws.detective.model.MembershipDatasources.ReadOnly
    ]] =
      AwsError.unwrapOptionField("membershipDatasources", membershipDatasources)
    def getUnprocessedGraphs: ZIO[Any, AwsError, List[
      zio.aws.detective.model.UnprocessedGraph.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedGraphs", unprocessedGraphs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesResponse
  ) extends zio.aws.detective.model.BatchGetMembershipDatasourcesResponse.ReadOnly {
    override val membershipDatasources: Optional[
      List[zio.aws.detective.model.MembershipDatasources.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.membershipDatasources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.detective.model.MembershipDatasources.wrap(item)
        }.toList
      )
    override val unprocessedGraphs
        : Optional[List[zio.aws.detective.model.UnprocessedGraph.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedGraphs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.detective.model.UnprocessedGraph.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.BatchGetMembershipDatasourcesResponse
  ): zio.aws.detective.model.BatchGetMembershipDatasourcesResponse.ReadOnly =
    new Wrapper(impl)
}
