package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{EmailMessage, GraphArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMembersRequest(
    graphArn: GraphArn,
    message: Optional[EmailMessage] = Optional.Absent,
    disableEmailNotification: Optional[Boolean] = Optional.Absent,
    accounts: Iterable[zio.aws.detective.model.Account]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.CreateMembersRequest = {
    import CreateMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.CreateMembersRequest
      .builder()
      .graphArn(GraphArn.unwrap(graphArn): java.lang.String)
      .optionallyWith(
        message.map(value => EmailMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        disableEmailNotification.map(value => value: java.lang.Boolean)
      )(_.disableEmailNotification)
      .accounts(accounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.CreateMembersRequest.ReadOnly =
    zio.aws.detective.model.CreateMembersRequest.wrap(buildAwsValue())
}
object CreateMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.CreateMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.CreateMembersRequest =
      zio.aws.detective.model.CreateMembersRequest(
        graphArn,
        message.map(value => value),
        disableEmailNotification.map(value => value),
        accounts.map { item =>
          item.asEditable
        }
      )
    def graphArn: GraphArn
    def message: Optional[EmailMessage]
    def disableEmailNotification: Optional[Boolean]
    def accounts: List[zio.aws.detective.model.Account.ReadOnly]
    def getGraphArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(graphArn)
    def getMessage: ZIO[Any, AwsError, EmailMessage] =
      AwsError.unwrapOptionField("message", message)
    def getDisableEmailNotification: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableEmailNotification", disableEmailNotification)
    def getAccounts
        : ZIO[Any, Nothing, List[zio.aws.detective.model.Account.ReadOnly]] =
      ZIO.succeed(accounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.CreateMembersRequest
  ) extends zio.aws.detective.model.CreateMembersRequest.ReadOnly {
    override val graphArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.graphArn())
    override val message: Optional[EmailMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.detective.model.primitives.EmailMessage(value))
    override val disableEmailNotification: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableEmailNotification())
        .map(value => value: Boolean)
    override val accounts: List[zio.aws.detective.model.Account.ReadOnly] = impl
      .accounts()
      .asScala
      .map { item =>
        zio.aws.detective.model.Account.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.CreateMembersRequest
  ): zio.aws.detective.model.CreateMembersRequest.ReadOnly = new Wrapper(impl)
}
