package zio.aws.detective.model
import scala.jdk.CollectionConverters.*
sealed trait DatasourcePackage {
  def unwrap: software.amazon.awssdk.services.detective.model.DatasourcePackage
}
object DatasourcePackage {
  def wrap(
      value: software.amazon.awssdk.services.detective.model.DatasourcePackage
  ): zio.aws.detective.model.DatasourcePackage = value match {
    case software.amazon.awssdk.services.detective.model.DatasourcePackage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.detective.model.DatasourcePackage.DETECTIVE_CORE =>
      val r = DETECTIVE_CORE
      r
    case software.amazon.awssdk.services.detective.model.DatasourcePackage.EKS_AUDIT =>
      val r = EKS_AUDIT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.detective.model.DatasourcePackage {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.DatasourcePackage =
      software.amazon.awssdk.services.detective.model.DatasourcePackage.UNKNOWN_TO_SDK_VERSION
  }
  case object DETECTIVE_CORE extends zio.aws.detective.model.DatasourcePackage {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.DatasourcePackage =
      software.amazon.awssdk.services.detective.model.DatasourcePackage.DETECTIVE_CORE
  }
  case object EKS_AUDIT extends zio.aws.detective.model.DatasourcePackage {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.DatasourcePackage =
      software.amazon.awssdk.services.detective.model.DatasourcePackage.EKS_AUDIT
  }
}
