package zio.aws.detective.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DatasourcePackageIngestDetail(
    datasourcePackageIngestState: Optional[
      zio.aws.detective.model.DatasourcePackageIngestState
    ] = Optional.Absent,
    lastIngestStateChange: Optional[Map[
      zio.aws.detective.model.DatasourcePackageIngestState,
      zio.aws.detective.model.TimestampForCollection
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.DatasourcePackageIngestDetail = {
    import DatasourcePackageIngestDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.DatasourcePackageIngestDetail
      .builder()
      .optionallyWith(datasourcePackageIngestState.map(value => value.unwrap))(
        _.datasourcePackageIngestState
      )
      .optionallyWith(
        lastIngestStateChange.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.lastIngestStateChangeWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.DatasourcePackageIngestDetail.ReadOnly =
    zio.aws.detective.model.DatasourcePackageIngestDetail.wrap(buildAwsValue())
}
object DatasourcePackageIngestDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.DatasourcePackageIngestDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.DatasourcePackageIngestDetail =
      zio.aws.detective.model.DatasourcePackageIngestDetail(
        datasourcePackageIngestState.map(value => value),
        lastIngestStateChange.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def datasourcePackageIngestState
        : Optional[zio.aws.detective.model.DatasourcePackageIngestState]
    def lastIngestStateChange: Optional[Map[
      zio.aws.detective.model.DatasourcePackageIngestState,
      zio.aws.detective.model.TimestampForCollection.ReadOnly
    ]]
    def getDatasourcePackageIngestState: ZIO[
      Any,
      AwsError,
      zio.aws.detective.model.DatasourcePackageIngestState
    ] = AwsError.unwrapOptionField(
      "datasourcePackageIngestState",
      datasourcePackageIngestState
    )
    def getLastIngestStateChange: ZIO[Any, AwsError, Map[
      zio.aws.detective.model.DatasourcePackageIngestState,
      zio.aws.detective.model.TimestampForCollection.ReadOnly
    ]] =
      AwsError.unwrapOptionField("lastIngestStateChange", lastIngestStateChange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.DatasourcePackageIngestDetail
  ) extends zio.aws.detective.model.DatasourcePackageIngestDetail.ReadOnly {
    override val datasourcePackageIngestState
        : Optional[zio.aws.detective.model.DatasourcePackageIngestState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasourcePackageIngestState())
        .map(value =>
          zio.aws.detective.model.DatasourcePackageIngestState.wrap(value)
        )
    override val lastIngestStateChange: Optional[Map[
      zio.aws.detective.model.DatasourcePackageIngestState,
      zio.aws.detective.model.TimestampForCollection.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.lastIngestStateChange())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.detective.model.DatasourcePackageIngestState.wrap(
              key
            ) -> zio.aws.detective.model.TimestampForCollection.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.DatasourcePackageIngestDetail
  ): zio.aws.detective.model.DatasourcePackageIngestDetail.ReadOnly =
    new Wrapper(impl)
}
