package zio.aws.detective.model
import scala.jdk.CollectionConverters.*
sealed trait DatasourcePackageIngestState {
  def unwrap: software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState
}
object DatasourcePackageIngestState {
  def wrap(
      value: software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState
  ): zio.aws.detective.model.DatasourcePackageIngestState = value match {
    case software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.detective.model.DatasourcePackageIngestState {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState =
      software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTED
      extends zio.aws.detective.model.DatasourcePackageIngestState {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState =
      software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState.STARTED
  }
  case object STOPPED
      extends zio.aws.detective.model.DatasourcePackageIngestState {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState =
      software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState.STOPPED
  }
  case object DISABLED
      extends zio.aws.detective.model.DatasourcePackageIngestState {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState =
      software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState.DISABLED
  }
}
