package zio.aws.detective.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.detective.model.primitives.{Timestamp, ByteValue}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DatasourcePackageUsageInfo(
    volumeUsageInBytes: Optional[ByteValue] = Optional.Absent,
    volumeUsageUpdateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.DatasourcePackageUsageInfo = {
    import DatasourcePackageUsageInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.DatasourcePackageUsageInfo
      .builder()
      .optionallyWith(
        volumeUsageInBytes.map(value => ByteValue.unwrap(value): java.lang.Long)
      )(_.volumeUsageInBytes)
      .optionallyWith(
        volumeUsageUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.volumeUsageUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.DatasourcePackageUsageInfo.ReadOnly =
    zio.aws.detective.model.DatasourcePackageUsageInfo.wrap(buildAwsValue())
}
object DatasourcePackageUsageInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.DatasourcePackageUsageInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.DatasourcePackageUsageInfo =
      zio.aws.detective.model.DatasourcePackageUsageInfo(
        volumeUsageInBytes.map(value => value),
        volumeUsageUpdateTime.map(value => value)
      )
    def volumeUsageInBytes: Optional[ByteValue]
    def volumeUsageUpdateTime: Optional[Timestamp]
    def getVolumeUsageInBytes: ZIO[Any, AwsError, ByteValue] =
      AwsError.unwrapOptionField("volumeUsageInBytes", volumeUsageInBytes)
    def getVolumeUsageUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("volumeUsageUpdateTime", volumeUsageUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.DatasourcePackageUsageInfo
  ) extends zio.aws.detective.model.DatasourcePackageUsageInfo.ReadOnly {
    override val volumeUsageInBytes: Optional[ByteValue] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeUsageInBytes())
      .map(value => zio.aws.detective.model.primitives.ByteValue(value))
    override val volumeUsageUpdateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeUsageUpdateTime())
        .map(value => zio.aws.detective.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.DatasourcePackageUsageInfo
  ): zio.aws.detective.model.DatasourcePackageUsageInfo.ReadOnly = new Wrapper(
    impl
  )
}
