package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.GraphArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteGraphRequest(graphArn: GraphArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.DeleteGraphRequest = {
    import DeleteGraphRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.DeleteGraphRequest
      .builder()
      .graphArn(GraphArn.unwrap(graphArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.DeleteGraphRequest.ReadOnly =
    zio.aws.detective.model.DeleteGraphRequest.wrap(buildAwsValue())
}
object DeleteGraphRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.DeleteGraphRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.DeleteGraphRequest =
      zio.aws.detective.model.DeleteGraphRequest(graphArn)
    def graphArn: GraphArn
    def getGraphArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(graphArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.DeleteGraphRequest
  ) extends zio.aws.detective.model.DeleteGraphRequest.ReadOnly {
    override val graphArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.graphArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.DeleteGraphRequest
  ): zio.aws.detective.model.DeleteGraphRequest.ReadOnly = new Wrapper(impl)
}
