package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.AccountId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteMembersResponse(
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    unprocessedAccounts: Optional[
      Iterable[zio.aws.detective.model.UnprocessedAccount]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.DeleteMembersResponse = {
    import DeleteMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.DeleteMembersResponse
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.DeleteMembersResponse.ReadOnly =
    zio.aws.detective.model.DeleteMembersResponse.wrap(buildAwsValue())
}
object DeleteMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.DeleteMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.DeleteMembersResponse =
      zio.aws.detective.model.DeleteMembersResponse(
        accountIds.map(value => value),
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountIds: Optional[List[AccountId]]
    def unprocessedAccounts
        : Optional[List[zio.aws.detective.model.UnprocessedAccount.ReadOnly]]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getUnprocessedAccounts: ZIO[Any, AwsError, List[
      zio.aws.detective.model.UnprocessedAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.DeleteMembersResponse
  ) extends zio.aws.detective.model.DeleteMembersResponse.ReadOnly {
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.detective.model.primitives.AccountId(item)
        }.toList
      )
    override val unprocessedAccounts
        : Optional[List[zio.aws.detective.model.UnprocessedAccount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.detective.model.UnprocessedAccount.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.DeleteMembersResponse
  ): zio.aws.detective.model.DeleteMembersResponse.ReadOnly = new Wrapper(impl)
}
