package zio.aws.detective.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConfigurationResponse(
    autoEnable: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.DescribeOrganizationConfigurationResponse = {
    import DescribeOrganizationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.DescribeOrganizationConfigurationResponse
      .builder()
      .optionallyWith(autoEnable.map(value => value: java.lang.Boolean))(
        _.autoEnable
      )
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    zio.aws.detective.model.DescribeOrganizationConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.DescribeOrganizationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.detective.model.DescribeOrganizationConfigurationResponse =
      zio.aws.detective.model.DescribeOrganizationConfigurationResponse(
        autoEnable.map(value => value)
      )
    def autoEnable: Optional[Boolean]
    def getAutoEnable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoEnable", autoEnable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.DescribeOrganizationConfigurationResponse
  ) extends zio.aws.detective.model.DescribeOrganizationConfigurationResponse.ReadOnly {
    override val autoEnable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoEnable())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.DescribeOrganizationConfigurationResponse
  ): zio.aws.detective.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
