package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.AccountId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EnableOrganizationAdminAccountRequest(accountId: AccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.EnableOrganizationAdminAccountRequest = {
    import EnableOrganizationAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.EnableOrganizationAdminAccountRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.EnableOrganizationAdminAccountRequest.ReadOnly =
    zio.aws.detective.model.EnableOrganizationAdminAccountRequest
      .wrap(buildAwsValue())
}
object EnableOrganizationAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.EnableOrganizationAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.detective.model.EnableOrganizationAdminAccountRequest =
      zio.aws.detective.model.EnableOrganizationAdminAccountRequest(accountId)
    def accountId: AccountId
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.EnableOrganizationAdminAccountRequest
  ) extends zio.aws.detective.model.EnableOrganizationAdminAccountRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.detective.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.EnableOrganizationAdminAccountRequest
  ): zio.aws.detective.model.EnableOrganizationAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
