package zio.aws.detective.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetMembersResponse(
    memberDetails: Optional[Iterable[zio.aws.detective.model.MemberDetail]] =
      Optional.Absent,
    unprocessedAccounts: Optional[
      Iterable[zio.aws.detective.model.UnprocessedAccount]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.GetMembersResponse = {
    import GetMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.GetMembersResponse
      .builder()
      .optionallyWith(
        memberDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memberDetails)
      .optionallyWith(
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.GetMembersResponse.ReadOnly =
    zio.aws.detective.model.GetMembersResponse.wrap(buildAwsValue())
}
object GetMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.GetMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.GetMembersResponse =
      zio.aws.detective.model.GetMembersResponse(
        memberDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def memberDetails
        : Optional[List[zio.aws.detective.model.MemberDetail.ReadOnly]]
    def unprocessedAccounts
        : Optional[List[zio.aws.detective.model.UnprocessedAccount.ReadOnly]]
    def getMemberDetails: ZIO[Any, AwsError, List[
      zio.aws.detective.model.MemberDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("memberDetails", memberDetails)
    def getUnprocessedAccounts: ZIO[Any, AwsError, List[
      zio.aws.detective.model.UnprocessedAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("unprocessedAccounts", unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.GetMembersResponse
  ) extends zio.aws.detective.model.GetMembersResponse.ReadOnly {
    override val memberDetails
        : Optional[List[zio.aws.detective.model.MemberDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.detective.model.MemberDetail.wrap(item)
          }.toList
        )
    override val unprocessedAccounts
        : Optional[List[zio.aws.detective.model.UnprocessedAccount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.detective.model.UnprocessedAccount.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.GetMembersResponse
  ): zio.aws.detective.model.GetMembersResponse.ReadOnly = new Wrapper(impl)
}
