package zio.aws.detective.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.detective.model.primitives.{Timestamp, GraphArn}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Graph(
    arn: Optional[GraphArn] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.detective.model.Graph = {
    import Graph.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.Graph
      .builder()
      .optionallyWith(
        arn.map(value => GraphArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.Graph.ReadOnly =
    zio.aws.detective.model.Graph.wrap(buildAwsValue())
}
object Graph {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.detective.model.Graph] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.Graph = zio.aws.detective.model
      .Graph(arn.map(value => value), createdTime.map(value => value))
    def arn: Optional[GraphArn]
    def createdTime: Optional[Timestamp]
    def getArn: ZIO[Any, AwsError, GraphArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.Graph
  ) extends zio.aws.detective.model.Graph.ReadOnly {
    override val arn: Optional[GraphArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.detective.model.primitives.GraphArn(value))
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.detective.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.Graph
  ): zio.aws.detective.model.Graph.ReadOnly = new Wrapper(impl)
}
