package zio.aws.detective.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.detective.model.primitives.{
  MemberResultsLimit,
  PaginationToken,
  GraphArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDatasourcePackagesRequest(
    graphArn: GraphArn,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MemberResultsLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.ListDatasourcePackagesRequest = {
    import ListDatasourcePackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.ListDatasourcePackagesRequest
      .builder()
      .graphArn(GraphArn.unwrap(graphArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MemberResultsLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.ListDatasourcePackagesRequest.ReadOnly =
    zio.aws.detective.model.ListDatasourcePackagesRequest.wrap(buildAwsValue())
}
object ListDatasourcePackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.ListDatasourcePackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.ListDatasourcePackagesRequest =
      zio.aws.detective.model.ListDatasourcePackagesRequest(
        graphArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def graphArn: GraphArn
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MemberResultsLimit]
    def getGraphArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(graphArn)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MemberResultsLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.ListDatasourcePackagesRequest
  ) extends zio.aws.detective.model.ListDatasourcePackagesRequest.ReadOnly {
    override val graphArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.graphArn())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.detective.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MemberResultsLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.detective.model.primitives.MemberResultsLimit(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.ListDatasourcePackagesRequest
  ): zio.aws.detective.model.ListDatasourcePackagesRequest.ReadOnly =
    new Wrapper(impl)
}
