package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDatasourcePackagesResponse(
    datasourcePackages: Optional[Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageIngestDetail
    ]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.ListDatasourcePackagesResponse = {
    import ListDatasourcePackagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.ListDatasourcePackagesResponse
      .builder()
      .optionallyWith(
        datasourcePackages.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.datasourcePackagesWithStrings)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.ListDatasourcePackagesResponse.ReadOnly =
    zio.aws.detective.model.ListDatasourcePackagesResponse.wrap(buildAwsValue())
}
object ListDatasourcePackagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.ListDatasourcePackagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.ListDatasourcePackagesResponse =
      zio.aws.detective.model.ListDatasourcePackagesResponse(
        datasourcePackages.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        nextToken.map(value => value)
      )
    def datasourcePackages: Optional[Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageIngestDetail.ReadOnly
    ]]
    def nextToken: Optional[PaginationToken]
    def getDatasourcePackages: ZIO[Any, AwsError, Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageIngestDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("datasourcePackages", datasourcePackages)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.ListDatasourcePackagesResponse
  ) extends zio.aws.detective.model.ListDatasourcePackagesResponse.ReadOnly {
    override val datasourcePackages: Optional[Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageIngestDetail.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.datasourcePackages())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.detective.model.DatasourcePackage.wrap(
              key
            ) -> zio.aws.detective.model.DatasourcePackageIngestDetail
              .wrap(value)
          })
          .toMap
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.detective.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.ListDatasourcePackagesResponse
  ): zio.aws.detective.model.ListDatasourcePackagesResponse.ReadOnly =
    new Wrapper(impl)
}
