package zio.aws.detective.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.detective.model.primitives.{MemberResultsLimit, PaginationToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListInvitationsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MemberResultsLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.ListInvitationsRequest = {
    import ListInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.ListInvitationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MemberResultsLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.ListInvitationsRequest.ReadOnly =
    zio.aws.detective.model.ListInvitationsRequest.wrap(buildAwsValue())
}
object ListInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.ListInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.ListInvitationsRequest =
      zio.aws.detective.model.ListInvitationsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MemberResultsLimit]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MemberResultsLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.ListInvitationsRequest
  ) extends zio.aws.detective.model.ListInvitationsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.detective.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MemberResultsLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.detective.model.primitives.MemberResultsLimit(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.ListInvitationsRequest
  ): zio.aws.detective.model.ListInvitationsRequest.ReadOnly = new Wrapper(impl)
}
