package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListMembersResponse(
    memberDetails: Optional[Iterable[zio.aws.detective.model.MemberDetail]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.ListMembersResponse = {
    import ListMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.ListMembersResponse
      .builder()
      .optionallyWith(
        memberDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.memberDetails)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.ListMembersResponse.ReadOnly =
    zio.aws.detective.model.ListMembersResponse.wrap(buildAwsValue())
}
object ListMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.ListMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.ListMembersResponse =
      zio.aws.detective.model.ListMembersResponse(
        memberDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def memberDetails
        : Optional[List[zio.aws.detective.model.MemberDetail.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getMemberDetails: ZIO[Any, AwsError, List[
      zio.aws.detective.model.MemberDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("memberDetails", memberDetails)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.ListMembersResponse
  ) extends zio.aws.detective.model.ListMembersResponse.ReadOnly {
    override val memberDetails
        : Optional[List[zio.aws.detective.model.MemberDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.detective.model.MemberDetail.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.detective.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.ListMembersResponse
  ): zio.aws.detective.model.ListMembersResponse.ReadOnly = new Wrapper(impl)
}
