package zio.aws.detective.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.detective.model.primitives.{
  EmailAddress,
  AccountId,
  Percentage,
  ByteValue,
  Timestamp,
  GraphArn
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class MemberDetail(
    accountId: Optional[AccountId] = Optional.Absent,
    emailAddress: Optional[EmailAddress] = Optional.Absent,
    graphArn: Optional[GraphArn] = Optional.Absent,
    masterId: Optional[AccountId] = Optional.Absent,
    administratorId: Optional[AccountId] = Optional.Absent,
    status: Optional[zio.aws.detective.model.MemberStatus] = Optional.Absent,
    disabledReason: Optional[zio.aws.detective.model.MemberDisabledReason] =
      Optional.Absent,
    invitedTime: Optional[Timestamp] = Optional.Absent,
    updatedTime: Optional[Timestamp] = Optional.Absent,
    volumeUsageInBytes: Optional[ByteValue] = Optional.Absent,
    volumeUsageUpdatedTime: Optional[Timestamp] = Optional.Absent,
    percentOfGraphUtilization: Optional[Percentage] = Optional.Absent,
    percentOfGraphUtilizationUpdatedTime: Optional[Timestamp] = Optional.Absent,
    invitationType: Optional[zio.aws.detective.model.InvitationType] =
      Optional.Absent,
    volumeUsageByDatasourcePackage: Optional[Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageUsageInfo
    ]] = Optional.Absent,
    datasourcePackageIngestStates: Optional[Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageIngestState
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.MemberDetail = {
    import MemberDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.MemberDetail
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        emailAddress.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        graphArn.map(value => GraphArn.unwrap(value): java.lang.String)
      )(_.graphArn)
      .optionallyWith(
        masterId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.masterId)
      .optionallyWith(
        administratorId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.administratorId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(disabledReason.map(value => value.unwrap))(
        _.disabledReason
      )
      .optionallyWith(
        invitedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.invitedTime)
      .optionallyWith(
        updatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.updatedTime)
      .optionallyWith(
        volumeUsageInBytes.map(value => ByteValue.unwrap(value): java.lang.Long)
      )(_.volumeUsageInBytes)
      .optionallyWith(
        volumeUsageUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.volumeUsageUpdatedTime)
      .optionallyWith(
        percentOfGraphUtilization.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.percentOfGraphUtilization)
      .optionallyWith(
        percentOfGraphUtilizationUpdatedTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.percentOfGraphUtilizationUpdatedTime)
      .optionallyWith(invitationType.map(value => value.unwrap))(
        _.invitationType
      )
      .optionallyWith(
        volumeUsageByDatasourcePackage.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.volumeUsageByDatasourcePackageWithStrings)
      .optionallyWith(
        datasourcePackageIngestStates.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.unwrap.toString
            })
            .asJava
        )
      )(_.datasourcePackageIngestStatesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.MemberDetail.ReadOnly =
    zio.aws.detective.model.MemberDetail.wrap(buildAwsValue())
}
object MemberDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.MemberDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.MemberDetail =
      zio.aws.detective.model.MemberDetail(
        accountId.map(value => value),
        emailAddress.map(value => value),
        graphArn.map(value => value),
        masterId.map(value => value),
        administratorId.map(value => value),
        status.map(value => value),
        disabledReason.map(value => value),
        invitedTime.map(value => value),
        updatedTime.map(value => value),
        volumeUsageInBytes.map(value => value),
        volumeUsageUpdatedTime.map(value => value),
        percentOfGraphUtilization.map(value => value),
        percentOfGraphUtilizationUpdatedTime.map(value => value),
        invitationType.map(value => value),
        volumeUsageByDatasourcePackage.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        datasourcePackageIngestStates.map(value => value)
      )
    def accountId: Optional[AccountId]
    def emailAddress: Optional[EmailAddress]
    def graphArn: Optional[GraphArn]
    def masterId: Optional[AccountId]
    def administratorId: Optional[AccountId]
    def status: Optional[zio.aws.detective.model.MemberStatus]
    def disabledReason: Optional[zio.aws.detective.model.MemberDisabledReason]
    def invitedTime: Optional[Timestamp]
    def updatedTime: Optional[Timestamp]
    def volumeUsageInBytes: Optional[ByteValue]
    def volumeUsageUpdatedTime: Optional[Timestamp]
    def percentOfGraphUtilization: Optional[Percentage]
    def percentOfGraphUtilizationUpdatedTime: Optional[Timestamp]
    def invitationType: Optional[zio.aws.detective.model.InvitationType]
    def volumeUsageByDatasourcePackage: Optional[Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageUsageInfo.ReadOnly
    ]]
    def datasourcePackageIngestStates: Optional[Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageIngestState
    ]]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getGraphArn: ZIO[Any, AwsError, GraphArn] =
      AwsError.unwrapOptionField("graphArn", graphArn)
    def getMasterId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("masterId", masterId)
    def getAdministratorId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("administratorId", administratorId)
    def getStatus: ZIO[Any, AwsError, zio.aws.detective.model.MemberStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDisabledReason
        : ZIO[Any, AwsError, zio.aws.detective.model.MemberDisabledReason] =
      AwsError.unwrapOptionField("disabledReason", disabledReason)
    def getInvitedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("invitedTime", invitedTime)
    def getUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedTime", updatedTime)
    def getVolumeUsageInBytes: ZIO[Any, AwsError, ByteValue] =
      AwsError.unwrapOptionField("volumeUsageInBytes", volumeUsageInBytes)
    def getVolumeUsageUpdatedTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("volumeUsageUpdatedTime", volumeUsageUpdatedTime)
    def getPercentOfGraphUtilization: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("percentOfGraphUtilization", percentOfGraphUtilization)
    def getPercentOfGraphUtilizationUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "percentOfGraphUtilizationUpdatedTime",
        percentOfGraphUtilizationUpdatedTime
      )
    def getInvitationType
        : ZIO[Any, AwsError, zio.aws.detective.model.InvitationType] =
      AwsError.unwrapOptionField("invitationType", invitationType)
    def getVolumeUsageByDatasourcePackage: ZIO[Any, AwsError, Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageUsageInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "volumeUsageByDatasourcePackage",
      volumeUsageByDatasourcePackage
    )
    def getDatasourcePackageIngestStates: ZIO[Any, AwsError, Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageIngestState
    ]] = AwsError.unwrapOptionField(
      "datasourcePackageIngestStates",
      datasourcePackageIngestStates
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.MemberDetail
  ) extends zio.aws.detective.model.MemberDetail.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.detective.model.primitives.AccountId(value))
    override val emailAddress: Optional[EmailAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value => zio.aws.detective.model.primitives.EmailAddress(value))
    override val graphArn: Optional[GraphArn] = zio.aws.core.internal
      .optionalFromNullable(impl.graphArn())
      .map(value => zio.aws.detective.model.primitives.GraphArn(value))
    override val masterId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.masterId())
      .map(value => zio.aws.detective.model.primitives.AccountId(value))
    override val administratorId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.administratorId())
      .map(value => zio.aws.detective.model.primitives.AccountId(value))
    override val status: Optional[zio.aws.detective.model.MemberStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.detective.model.MemberStatus.wrap(value))
    override val disabledReason
        : Optional[zio.aws.detective.model.MemberDisabledReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disabledReason())
        .map(value => zio.aws.detective.model.MemberDisabledReason.wrap(value))
    override val invitedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.invitedTime())
      .map(value => zio.aws.detective.model.primitives.Timestamp(value))
    override val updatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedTime())
      .map(value => zio.aws.detective.model.primitives.Timestamp(value))
    override val volumeUsageInBytes: Optional[ByteValue] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeUsageInBytes())
      .map(value => zio.aws.detective.model.primitives.ByteValue(value))
    override val volumeUsageUpdatedTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeUsageUpdatedTime())
        .map(value => zio.aws.detective.model.primitives.Timestamp(value))
    override val percentOfGraphUtilization: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.percentOfGraphUtilization())
        .map(value => zio.aws.detective.model.primitives.Percentage(value))
    override val percentOfGraphUtilizationUpdatedTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.percentOfGraphUtilizationUpdatedTime())
        .map(value => zio.aws.detective.model.primitives.Timestamp(value))
    override val invitationType
        : Optional[zio.aws.detective.model.InvitationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invitationType())
        .map(value => zio.aws.detective.model.InvitationType.wrap(value))
    override val volumeUsageByDatasourcePackage: Optional[Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageUsageInfo.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeUsageByDatasourcePackage())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.detective.model.DatasourcePackage.wrap(
              key
            ) -> zio.aws.detective.model.DatasourcePackageUsageInfo.wrap(value)
          })
          .toMap
      )
    override val datasourcePackageIngestStates: Optional[Map[
      zio.aws.detective.model.DatasourcePackage,
      zio.aws.detective.model.DatasourcePackageIngestState
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.datasourcePackageIngestStates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.detective.model.DatasourcePackage
              .wrap(key) -> zio.aws.detective.model.DatasourcePackageIngestState
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.MemberDetail
  ): zio.aws.detective.model.MemberDetail.ReadOnly = new Wrapper(impl)
}
