package zio.aws.detective.model
import scala.jdk.CollectionConverters.*
sealed trait MemberStatus {
  def unwrap: software.amazon.awssdk.services.detective.model.MemberStatus
}
object MemberStatus {
  def wrap(
      value: software.amazon.awssdk.services.detective.model.MemberStatus
  ): zio.aws.detective.model.MemberStatus = value match {
    case software.amazon.awssdk.services.detective.model.MemberStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.detective.model.MemberStatus.INVITED =>
      val r = INVITED
      r
    case software.amazon.awssdk.services.detective.model.MemberStatus.VERIFICATION_IN_PROGRESS =>
      val r = VERIFICATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.detective.model.MemberStatus.VERIFICATION_FAILED =>
      val r = VERIFICATION_FAILED
      r
    case software.amazon.awssdk.services.detective.model.MemberStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.detective.model.MemberStatus.ACCEPTED_BUT_DISABLED =>
      val r = ACCEPTED_BUT_DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.detective.model.MemberStatus {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.MemberStatus =
      software.amazon.awssdk.services.detective.model.MemberStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INVITED extends zio.aws.detective.model.MemberStatus {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.MemberStatus =
      software.amazon.awssdk.services.detective.model.MemberStatus.INVITED
  }
  case object VERIFICATION_IN_PROGRESS
      extends zio.aws.detective.model.MemberStatus {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.MemberStatus =
      software.amazon.awssdk.services.detective.model.MemberStatus.VERIFICATION_IN_PROGRESS
  }
  case object VERIFICATION_FAILED extends zio.aws.detective.model.MemberStatus {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.MemberStatus =
      software.amazon.awssdk.services.detective.model.MemberStatus.VERIFICATION_FAILED
  }
  case object ENABLED extends zio.aws.detective.model.MemberStatus {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.MemberStatus =
      software.amazon.awssdk.services.detective.model.MemberStatus.ENABLED
  }
  case object ACCEPTED_BUT_DISABLED
      extends zio.aws.detective.model.MemberStatus {
    override def unwrap
        : software.amazon.awssdk.services.detective.model.MemberStatus =
      software.amazon.awssdk.services.detective.model.MemberStatus.ACCEPTED_BUT_DISABLED
  }
}
