package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{GraphArn, AccountId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MembershipDatasources(
    accountId: Optional[AccountId] = Optional.Absent,
    graphArn: Optional[GraphArn] = Optional.Absent,
    datasourcePackageIngestHistory: Optional[
      Map[zio.aws.detective.model.DatasourcePackage, Map[
        zio.aws.detective.model.DatasourcePackageIngestState,
        zio.aws.detective.model.TimestampForCollection
      ]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.MembershipDatasources = {
    import MembershipDatasources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.MembershipDatasources
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        graphArn.map(value => GraphArn.unwrap(value): java.lang.String)
      )(_.graphArn)
      .optionallyWith(
        datasourcePackageIngestHistory.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value
                .map({ case (key, value) =>
                  key.unwrap.toString -> value.buildAwsValue()
                })
                .asJava
            })
            .asJava
        )
      )(_.datasourcePackageIngestHistoryWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.MembershipDatasources.ReadOnly =
    zio.aws.detective.model.MembershipDatasources.wrap(buildAwsValue())
}
object MembershipDatasources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.MembershipDatasources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.MembershipDatasources =
      zio.aws.detective.model.MembershipDatasources(
        accountId.map(value => value),
        graphArn.map(value => value),
        datasourcePackageIngestHistory.map(value =>
          value.map({ case (key, value) =>
            key -> value.map({ case (key, value) =>
              key -> value.asEditable
            })
          })
        )
      )
    def accountId: Optional[AccountId]
    def graphArn: Optional[GraphArn]
    def datasourcePackageIngestHistory
        : Optional[Map[zio.aws.detective.model.DatasourcePackage, Map[
          zio.aws.detective.model.DatasourcePackageIngestState,
          zio.aws.detective.model.TimestampForCollection.ReadOnly
        ]]]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getGraphArn: ZIO[Any, AwsError, GraphArn] =
      AwsError.unwrapOptionField("graphArn", graphArn)
    def getDatasourcePackageIngestHistory
        : ZIO[Any, AwsError, Map[zio.aws.detective.model.DatasourcePackage, Map[
          zio.aws.detective.model.DatasourcePackageIngestState,
          zio.aws.detective.model.TimestampForCollection.ReadOnly
        ]]] = AwsError.unwrapOptionField(
      "datasourcePackageIngestHistory",
      datasourcePackageIngestHistory
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.MembershipDatasources
  ) extends zio.aws.detective.model.MembershipDatasources.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.detective.model.primitives.AccountId(value))
    override val graphArn: Optional[GraphArn] = zio.aws.core.internal
      .optionalFromNullable(impl.graphArn())
      .map(value => zio.aws.detective.model.primitives.GraphArn(value))
    override val datasourcePackageIngestHistory
        : Optional[Map[zio.aws.detective.model.DatasourcePackage, Map[
          zio.aws.detective.model.DatasourcePackageIngestState,
          zio.aws.detective.model.TimestampForCollection.ReadOnly
        ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.datasourcePackageIngestHistory())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.detective.model.DatasourcePackage.wrap(key) -> value.asScala
              .map({ case (key, value) =>
                zio.aws.detective.model.DatasourcePackageIngestState.wrap(
                  key
                ) -> zio.aws.detective.model.TimestampForCollection.wrap(value)
              })
              .toMap
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.MembershipDatasources
  ): zio.aws.detective.model.MembershipDatasources.ReadOnly = new Wrapper(impl)
}
