package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.GraphArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RejectInvitationRequest(graphArn: GraphArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.RejectInvitationRequest = {
    import RejectInvitationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.RejectInvitationRequest
      .builder()
      .graphArn(GraphArn.unwrap(graphArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.RejectInvitationRequest.ReadOnly =
    zio.aws.detective.model.RejectInvitationRequest.wrap(buildAwsValue())
}
object RejectInvitationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.RejectInvitationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.RejectInvitationRequest =
      zio.aws.detective.model.RejectInvitationRequest(graphArn)
    def graphArn: GraphArn
    def getGraphArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(graphArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.RejectInvitationRequest
  ) extends zio.aws.detective.model.RejectInvitationRequest.ReadOnly {
    override val graphArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.graphArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.RejectInvitationRequest
  ): zio.aws.detective.model.RejectInvitationRequest.ReadOnly = new Wrapper(
    impl
  )
}
