package zio.aws.detective.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.detective.model.primitives.Timestamp
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TimestampForCollection(
    timestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.TimestampForCollection = {
    import TimestampForCollection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.TimestampForCollection
      .builder()
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.detective.model.TimestampForCollection.ReadOnly =
    zio.aws.detective.model.TimestampForCollection.wrap(buildAwsValue())
}
object TimestampForCollection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.TimestampForCollection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.TimestampForCollection =
      zio.aws.detective.model
        .TimestampForCollection(timestamp.map(value => value))
    def timestamp: Optional[Timestamp]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.TimestampForCollection
  ) extends zio.aws.detective.model.TimestampForCollection.ReadOnly {
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.detective.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.TimestampForCollection
  ): zio.aws.detective.model.TimestampForCollection.ReadOnly = new Wrapper(impl)
}
