package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{UnprocessedReason, AccountId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UnprocessedAccount(
    accountId: Optional[AccountId] = Optional.Absent,
    reason: Optional[UnprocessedReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.UnprocessedAccount = {
    import UnprocessedAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.UnprocessedAccount
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        reason.map(value => UnprocessedReason.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.UnprocessedAccount.ReadOnly =
    zio.aws.detective.model.UnprocessedAccount.wrap(buildAwsValue())
}
object UnprocessedAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.UnprocessedAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.UnprocessedAccount =
      zio.aws.detective.model.UnprocessedAccount(
        accountId.map(value => value),
        reason.map(value => value)
      )
    def accountId: Optional[AccountId]
    def reason: Optional[UnprocessedReason]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getReason: ZIO[Any, AwsError, UnprocessedReason] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.UnprocessedAccount
  ) extends zio.aws.detective.model.UnprocessedAccount.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.detective.model.primitives.AccountId(value))
    override val reason: Optional[UnprocessedReason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.detective.model.primitives.UnprocessedReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.UnprocessedAccount
  ): zio.aws.detective.model.UnprocessedAccount.ReadOnly = new Wrapper(impl)
}
