package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{UnprocessedReason, GraphArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UnprocessedGraph(
    graphArn: Optional[GraphArn] = Optional.Absent,
    reason: Optional[UnprocessedReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.UnprocessedGraph = {
    import UnprocessedGraph.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.UnprocessedGraph
      .builder()
      .optionallyWith(
        graphArn.map(value => GraphArn.unwrap(value): java.lang.String)
      )(_.graphArn)
      .optionallyWith(
        reason.map(value => UnprocessedReason.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.UnprocessedGraph.ReadOnly =
    zio.aws.detective.model.UnprocessedGraph.wrap(buildAwsValue())
}
object UnprocessedGraph {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.UnprocessedGraph
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.UnprocessedGraph =
      zio.aws.detective.model.UnprocessedGraph(
        graphArn.map(value => value),
        reason.map(value => value)
      )
    def graphArn: Optional[GraphArn]
    def reason: Optional[UnprocessedReason]
    def getGraphArn: ZIO[Any, AwsError, GraphArn] =
      AwsError.unwrapOptionField("graphArn", graphArn)
    def getReason: ZIO[Any, AwsError, UnprocessedReason] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.UnprocessedGraph
  ) extends zio.aws.detective.model.UnprocessedGraph.ReadOnly {
    override val graphArn: Optional[GraphArn] = zio.aws.core.internal
      .optionalFromNullable(impl.graphArn())
      .map(value => zio.aws.detective.model.primitives.GraphArn(value))
    override val reason: Optional[UnprocessedReason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.detective.model.primitives.UnprocessedReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.UnprocessedGraph
  ): zio.aws.detective.model.UnprocessedGraph.ReadOnly = new Wrapper(impl)
}
