package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.{TagKey, GraphArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: GraphArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.UntagResourceRequest
      .builder()
      .resourceArn(GraphArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.detective.model.UntagResourceRequest.ReadOnly =
    zio.aws.detective.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.UntagResourceRequest =
      zio.aws.detective.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: GraphArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.UntagResourceRequest
  ) extends zio.aws.detective.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.detective.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.UntagResourceRequest
  ): zio.aws.detective.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
