package zio.aws.detective.model
import zio.ZIO
import zio.aws.detective.model.primitives.GraphArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateDatasourcePackagesRequest(
    graphArn: GraphArn,
    datasourcePackages: Iterable[zio.aws.detective.model.DatasourcePackage]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.detective.model.UpdateDatasourcePackagesRequest = {
    import UpdateDatasourcePackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.detective.model.UpdateDatasourcePackagesRequest
      .builder()
      .graphArn(GraphArn.unwrap(graphArn): java.lang.String)
      .datasourcePackagesWithStrings(datasourcePackages.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.detective.model.UpdateDatasourcePackagesRequest.ReadOnly =
    zio.aws.detective.model.UpdateDatasourcePackagesRequest
      .wrap(buildAwsValue())
}
object UpdateDatasourcePackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.detective.model.UpdateDatasourcePackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.detective.model.UpdateDatasourcePackagesRequest =
      zio.aws.detective.model
        .UpdateDatasourcePackagesRequest(graphArn, datasourcePackages)
    def graphArn: GraphArn
    def datasourcePackages: List[zio.aws.detective.model.DatasourcePackage]
    def getGraphArn: ZIO[Any, Nothing, GraphArn] = ZIO.succeed(graphArn)
    def getDatasourcePackages
        : ZIO[Any, Nothing, List[zio.aws.detective.model.DatasourcePackage]] =
      ZIO.succeed(datasourcePackages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.detective.model.UpdateDatasourcePackagesRequest
  ) extends zio.aws.detective.model.UpdateDatasourcePackagesRequest.ReadOnly {
    override val graphArn: GraphArn =
      zio.aws.detective.model.primitives.GraphArn(impl.graphArn())
    override val datasourcePackages
        : List[zio.aws.detective.model.DatasourcePackage] = impl
      .datasourcePackages()
      .asScala
      .map { item =>
        zio.aws.detective.model.DatasourcePackage.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.detective.model.UpdateDatasourcePackagesRequest
  ): zio.aws.detective.model.UpdateDatasourcePackagesRequest.ReadOnly =
    new Wrapper(impl)
}
