package zio.aws.detective
import zio.prelude.Subtype
import zio.aws.detective.model.primitives.{
  TagValue,
  TagKey,
  GraphArn,
  AccountId
}
import java.time.Instant
import zio.aws.detective.model.primitives.TagValue.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.detective.model.primitives.AccountId.Type
    object ByteValue extends Subtype[Long]
    type ByteValue = zio.aws.detective.model.primitives.ByteValue.Type
    object EmailAddress extends Subtype[String]
    type EmailAddress = zio.aws.detective.model.primitives.EmailAddress.Type
    object EmailMessage extends Subtype[String]
    type EmailMessage = zio.aws.detective.model.primitives.EmailMessage.Type
    object GraphArn extends Subtype[String]
    type GraphArn = zio.aws.detective.model.primitives.GraphArn.Type
    object MemberResultsLimit extends Subtype[Int]
    type MemberResultsLimit =
      zio.aws.detective.model.primitives.MemberResultsLimit.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.detective.model.primitives.PaginationToken.Type
    object Percentage extends Subtype[Double]
    type Percentage = zio.aws.detective.model.primitives.Percentage.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.detective.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.detective.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.detective.model.primitives.Timestamp.Type
    object UnprocessedReason extends Subtype[String]
    type UnprocessedReason =
      zio.aws.detective.model.primitives.UnprocessedReason.Type
  }
  type AccountIdExtendedList = List[AccountId]
  type AccountIdList = List[AccountId]
  type AccountList = List[zio.aws.detective.model.Account]
  type AdministratorList = List[zio.aws.detective.model.Administrator]
  type DatasourcePackageIngestDetails = Map[
    zio.aws.detective.model.DatasourcePackage,
    zio.aws.detective.model.DatasourcePackageIngestDetail
  ]
  type DatasourcePackageIngestHistory =
    Map[zio.aws.detective.model.DatasourcePackage, Map[
      zio.aws.detective.model.DatasourcePackageIngestState,
      zio.aws.detective.model.TimestampForCollection
    ]]
  type DatasourcePackageIngestStates = Map[
    zio.aws.detective.model.DatasourcePackage,
    zio.aws.detective.model.DatasourcePackageIngestState
  ]
  type DatasourcePackageList = List[zio.aws.detective.model.DatasourcePackage]
  type GraphArnList = List[GraphArn]
  type GraphList = List[zio.aws.detective.model.Graph]
  type LastIngestStateChangeDates = Map[
    zio.aws.detective.model.DatasourcePackageIngestState,
    zio.aws.detective.model.TimestampForCollection
  ]
  type MemberDetailList = List[zio.aws.detective.model.MemberDetail]
  type MembershipDatasourcesList =
    List[zio.aws.detective.model.MembershipDatasources]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type UnprocessedAccountList = List[zio.aws.detective.model.UnprocessedAccount]
  type UnprocessedGraphList = List[zio.aws.detective.model.UnprocessedGraph]
  type VolumeUsageByDatasourcePackage = Map[
    zio.aws.detective.model.DatasourcePackage,
    zio.aws.detective.model.DatasourcePackageUsageInfo
  ]
}
