package zio.aws.devicefarm
import zio.aws.devicefarm.model.UpdateTestGridProjectResponse.ReadOnly
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.devicefarm.model.{
  UpdateUploadRequest,
  InstallToRemoteAccessSessionRequest,
  ListUniqueProblemsRequest,
  StopRemoteAccessSessionRequest,
  UpdateInstanceProfileRequest,
  ScheduleRunRequest,
  GetDevicePoolRequest,
  CreateVpceConfigurationRequest,
  DeleteDevicePoolRequest,
  PurchaseOfferingRequest,
  GetDevicePoolCompatibilityRequest,
  ListTestGridProjectsRequest,
  ListInstanceProfilesRequest,
  CreateTestGridUrlRequest,
  GetProjectRequest,
  CreateProjectRequest,
  CreateTestGridProjectRequest,
  GetTestGridSessionRequest,
  GetInstanceProfileRequest,
  CreateInstanceProfileRequest,
  GetTestRequest,
  ListVpceConfigurationsRequest,
  ListOfferingsRequest,
  GetRunRequest,
  GetUploadRequest,
  GetSuiteRequest,
  ListJobsRequest,
  ListTestsRequest,
  GetJobRequest,
  ListTestGridSessionArtifactsRequest,
  GetDeviceRequest,
  ListTagsForResourceRequest,
  ListRunsRequest,
  DeleteNetworkProfileRequest,
  DeleteRunRequest,
  DeleteInstanceProfileRequest,
  CreateDevicePoolRequest,
  GetVpceConfigurationRequest,
  UpdateDevicePoolRequest,
  DeleteTestGridProjectRequest,
  UpdateNetworkProfileRequest,
  GetNetworkProfileRequest,
  ListRemoteAccessSessionsRequest,
  UpdateProjectRequest,
  ListNetworkProfilesRequest,
  GetTestGridProjectRequest,
  DeleteUploadRequest,
  GetOfferingStatusRequest,
  DeleteProjectRequest,
  ListArtifactsRequest,
  GetDeviceInstanceRequest,
  DeleteVpceConfigurationRequest,
  GetRemoteAccessSessionRequest,
  ListTestGridSessionsRequest,
  ListDeviceInstancesRequest,
  CreateRemoteAccessSessionRequest,
  RenewOfferingRequest,
  UpdateDeviceInstanceRequest,
  UpdateTestGridProjectRequest,
  ListDevicePoolsRequest,
  ListProjectsRequest,
  UntagResourceRequest,
  ListTestGridSessionActionsRequest,
  StopRunRequest,
  ListUploadsRequest,
  ListOfferingPromotionsRequest,
  ListDevicesRequest,
  CreateNetworkProfileRequest,
  ListSuitesRequest,
  CreateUploadRequest,
  ListOfferingTransactionsRequest,
  ListSamplesRequest,
  UpdateVpceConfigurationRequest,
  GetAccountSettingsRequest,
  DeleteRemoteAccessSessionRequest,
  TagResourceRequest,
  StopJobRequest
}
object DeviceFarmMock extends Mock[DeviceFarm] {
  object ListTestGridSessionActions
      extends Effect[
        ListTestGridSessionActionsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListTestGridSessionActionsResponse.ReadOnly
      ]
  object ListTestGridSessions
      extends Effect[
        ListTestGridSessionsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListTestGridSessionsResponse.ReadOnly
      ]
  object GetProject
      extends Effect[
        GetProjectRequest,
        AwsError,
        zio.aws.devicefarm.model.GetProjectResponse.ReadOnly
      ]
  object UpdateInstanceProfile
      extends Effect[
        UpdateInstanceProfileRequest,
        AwsError,
        zio.aws.devicefarm.model.UpdateInstanceProfileResponse.ReadOnly
      ]
  object ListTestGridProjects
      extends Effect[
        ListTestGridProjectsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListTestGridProjectsResponse.ReadOnly
      ]
  object UpdateDeviceInstance
      extends Effect[
        UpdateDeviceInstanceRequest,
        AwsError,
        zio.aws.devicefarm.model.UpdateDeviceInstanceResponse.ReadOnly
      ]
  object InstallToRemoteAccessSession
      extends Effect[
        InstallToRemoteAccessSessionRequest,
        AwsError,
        zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse.ReadOnly
      ]
  object UpdateTestGridProject
      extends Effect[UpdateTestGridProjectRequest, AwsError, ReadOnly]
  object UpdateVPCEConfiguration
      extends Effect[
        UpdateVpceConfigurationRequest,
        AwsError,
        zio.aws.devicefarm.model.UpdateVpceConfigurationResponse.ReadOnly
      ]
  object GetUpload
      extends Effect[
        GetUploadRequest,
        AwsError,
        zio.aws.devicefarm.model.GetUploadResponse.ReadOnly
      ]
  object UpdateProject
      extends Effect[
        UpdateProjectRequest,
        AwsError,
        zio.aws.devicefarm.model.UpdateProjectResponse.ReadOnly
      ]
  object UpdateNetworkProfile
      extends Effect[
        UpdateNetworkProfileRequest,
        AwsError,
        zio.aws.devicefarm.model.UpdateNetworkProfileResponse.ReadOnly
      ]
  object UpdateUpload
      extends Effect[
        UpdateUploadRequest,
        AwsError,
        zio.aws.devicefarm.model.UpdateUploadResponse.ReadOnly
      ]
  object CreateTestGridUrl
      extends Effect[
        CreateTestGridUrlRequest,
        AwsError,
        zio.aws.devicefarm.model.CreateTestGridUrlResponse.ReadOnly
      ]
  object GetRun
      extends Effect[
        GetRunRequest,
        AwsError,
        zio.aws.devicefarm.model.GetRunResponse.ReadOnly
      ]
  object ListDeviceInstances
      extends Effect[
        ListDeviceInstancesRequest,
        AwsError,
        zio.aws.devicefarm.model.ListDeviceInstancesResponse.ReadOnly
      ]
  object ListSuites
      extends Stream[
        ListSuitesRequest,
        AwsError,
        zio.aws.devicefarm.model.Suite.ReadOnly
      ]
  object ListSuitesPaginated
      extends Effect[
        ListSuitesRequest,
        AwsError,
        zio.aws.devicefarm.model.ListSuitesResponse.ReadOnly
      ]
  object DeleteRemoteAccessSession
      extends Effect[
        DeleteRemoteAccessSessionRequest,
        AwsError,
        zio.aws.devicefarm.model.DeleteRemoteAccessSessionResponse.ReadOnly
      ]
  object GetVPCEConfiguration
      extends Effect[
        GetVpceConfigurationRequest,
        AwsError,
        zio.aws.devicefarm.model.GetVpceConfigurationResponse.ReadOnly
      ]
  object StopJob
      extends Effect[
        StopJobRequest,
        AwsError,
        zio.aws.devicefarm.model.StopJobResponse.ReadOnly
      ]
  object GetNetworkProfile
      extends Effect[
        GetNetworkProfileRequest,
        AwsError,
        zio.aws.devicefarm.model.GetNetworkProfileResponse.ReadOnly
      ]
  object CreateDevicePool
      extends Effect[
        CreateDevicePoolRequest,
        AwsError,
        zio.aws.devicefarm.model.CreateDevicePoolResponse.ReadOnly
      ]
  object ListDevices
      extends Stream[
        ListDevicesRequest,
        AwsError,
        zio.aws.devicefarm.model.Device.ReadOnly
      ]
  object ListDevicesPaginated
      extends Effect[
        ListDevicesRequest,
        AwsError,
        zio.aws.devicefarm.model.ListDevicesResponse.ReadOnly
      ]
  object GetRemoteAccessSession
      extends Effect[
        GetRemoteAccessSessionRequest,
        AwsError,
        zio.aws.devicefarm.model.GetRemoteAccessSessionResponse.ReadOnly
      ]
  object ListRemoteAccessSessions
      extends Effect[
        ListRemoteAccessSessionsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse.ReadOnly
      ]
  object ListProjects
      extends Stream[
        ListProjectsRequest,
        AwsError,
        zio.aws.devicefarm.model.Project.ReadOnly
      ]
  object ListProjectsPaginated
      extends Effect[
        ListProjectsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListProjectsResponse.ReadOnly
      ]
  object ScheduleRun
      extends Effect[
        ScheduleRunRequest,
        AwsError,
        zio.aws.devicefarm.model.ScheduleRunResponse.ReadOnly
      ]
  object GetDevicePoolCompatibility
      extends Effect[
        GetDevicePoolCompatibilityRequest,
        AwsError,
        zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse.ReadOnly
      ]
  object ListUploads
      extends Stream[
        ListUploadsRequest,
        AwsError,
        zio.aws.devicefarm.model.Upload.ReadOnly
      ]
  object ListUploadsPaginated
      extends Effect[
        ListUploadsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListUploadsResponse.ReadOnly
      ]
  object DeleteUpload
      extends Effect[
        DeleteUploadRequest,
        AwsError,
        zio.aws.devicefarm.model.DeleteUploadResponse.ReadOnly
      ]
  object ListRuns
      extends Stream[
        ListRunsRequest,
        AwsError,
        zio.aws.devicefarm.model.Run.ReadOnly
      ]
  object ListRunsPaginated
      extends Effect[
        ListRunsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListRunsResponse.ReadOnly
      ]
  object UpdateDevicePool
      extends Effect[
        UpdateDevicePoolRequest,
        AwsError,
        zio.aws.devicefarm.model.UpdateDevicePoolResponse.ReadOnly
      ]
  object ListArtifacts
      extends Stream[
        ListArtifactsRequest,
        AwsError,
        zio.aws.devicefarm.model.Artifact.ReadOnly
      ]
  object ListArtifactsPaginated
      extends Effect[
        ListArtifactsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListArtifactsResponse.ReadOnly
      ]
  object GetTestGridProject
      extends Effect[
        GetTestGridProjectRequest,
        AwsError,
        zio.aws.devicefarm.model.GetTestGridProjectResponse.ReadOnly
      ]
  object StopRemoteAccessSession
      extends Effect[
        StopRemoteAccessSessionRequest,
        AwsError,
        zio.aws.devicefarm.model.StopRemoteAccessSessionResponse.ReadOnly
      ]
  object ListDevicePools
      extends Stream[
        ListDevicePoolsRequest,
        AwsError,
        zio.aws.devicefarm.model.DevicePool.ReadOnly
      ]
  object ListDevicePoolsPaginated
      extends Effect[
        ListDevicePoolsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListDevicePoolsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.devicefarm.model.UntagResourceResponse.ReadOnly
      ]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.devicefarm.model.CreateProjectResponse.ReadOnly
      ]
  object CreateRemoteAccessSession
      extends Effect[
        CreateRemoteAccessSessionRequest,
        AwsError,
        zio.aws.devicefarm.model.CreateRemoteAccessSessionResponse.ReadOnly
      ]
  object StopRun
      extends Effect[
        StopRunRequest,
        AwsError,
        zio.aws.devicefarm.model.StopRunResponse.ReadOnly
      ]
  object ListUniqueProblems
      extends Effect[
        ListUniqueProblemsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListUniqueProblemsResponse.ReadOnly
      ]
  object GetJob
      extends Effect[
        GetJobRequest,
        AwsError,
        zio.aws.devicefarm.model.GetJobResponse.ReadOnly
      ]
  object ListOfferingTransactions
      extends Stream[
        ListOfferingTransactionsRequest,
        AwsError,
        zio.aws.devicefarm.model.OfferingTransaction.ReadOnly
      ]
  object ListOfferingTransactionsPaginated
      extends Effect[
        ListOfferingTransactionsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListOfferingTransactionsResponse.ReadOnly
      ]
  object ListOfferings
      extends Stream[
        ListOfferingsRequest,
        AwsError,
        zio.aws.devicefarm.model.Offering.ReadOnly
      ]
  object ListOfferingsPaginated
      extends Effect[
        ListOfferingsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListOfferingsResponse.ReadOnly
      ]
  object DeleteInstanceProfile
      extends Effect[
        DeleteInstanceProfileRequest,
        AwsError,
        zio.aws.devicefarm.model.DeleteInstanceProfileResponse.ReadOnly
      ]
  object CreateTestGridProject
      extends Effect[
        CreateTestGridProjectRequest,
        AwsError,
        zio.aws.devicefarm.model.CreateTestGridProjectResponse.ReadOnly
      ]
  object ListOfferingPromotions
      extends Effect[
        ListOfferingPromotionsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListOfferingPromotionsResponse.ReadOnly
      ]
  object GetSuite
      extends Effect[
        GetSuiteRequest,
        AwsError,
        zio.aws.devicefarm.model.GetSuiteResponse.ReadOnly
      ]
  object GetOfferingStatus
      extends Effect[
        GetOfferingStatusRequest,
        AwsError,
        zio.aws.devicefarm.model.GetOfferingStatusResponse.ReadOnly
      ]
  object DeleteVPCEConfiguration
      extends Effect[
        DeleteVpceConfigurationRequest,
        AwsError,
        zio.aws.devicefarm.model.DeleteVpceConfigurationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.devicefarm.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListJobs
      extends Stream[
        ListJobsRequest,
        AwsError,
        zio.aws.devicefarm.model.Job.ReadOnly
      ]
  object ListJobsPaginated
      extends Effect[
        ListJobsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListJobsResponse.ReadOnly
      ]
  object DeleteRun
      extends Effect[
        DeleteRunRequest,
        AwsError,
        zio.aws.devicefarm.model.DeleteRunResponse.ReadOnly
      ]
  object DeleteDevicePool
      extends Effect[
        DeleteDevicePoolRequest,
        AwsError,
        zio.aws.devicefarm.model.DeleteDevicePoolResponse.ReadOnly
      ]
  object GetInstanceProfile
      extends Effect[
        GetInstanceProfileRequest,
        AwsError,
        zio.aws.devicefarm.model.GetInstanceProfileResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.devicefarm.model.TagResourceResponse.ReadOnly
      ]
  object ListTests
      extends Stream[
        ListTestsRequest,
        AwsError,
        zio.aws.devicefarm.model.Test.ReadOnly
      ]
  object ListTestsPaginated
      extends Effect[
        ListTestsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListTestsResponse.ReadOnly
      ]
  object DeleteNetworkProfile
      extends Effect[
        DeleteNetworkProfileRequest,
        AwsError,
        zio.aws.devicefarm.model.DeleteNetworkProfileResponse.ReadOnly
      ]
  object PurchaseOffering
      extends Effect[
        PurchaseOfferingRequest,
        AwsError,
        zio.aws.devicefarm.model.PurchaseOfferingResponse.ReadOnly
      ]
  object ListInstanceProfiles
      extends Effect[
        ListInstanceProfilesRequest,
        AwsError,
        zio.aws.devicefarm.model.ListInstanceProfilesResponse.ReadOnly
      ]
  object GetTest
      extends Effect[
        GetTestRequest,
        AwsError,
        zio.aws.devicefarm.model.GetTestResponse.ReadOnly
      ]
  object ListNetworkProfiles
      extends Effect[
        ListNetworkProfilesRequest,
        AwsError,
        zio.aws.devicefarm.model.ListNetworkProfilesResponse.ReadOnly
      ]
  object GetDeviceInstance
      extends Effect[
        GetDeviceInstanceRequest,
        AwsError,
        zio.aws.devicefarm.model.GetDeviceInstanceResponse.ReadOnly
      ]
  object CreateInstanceProfile
      extends Effect[
        CreateInstanceProfileRequest,
        AwsError,
        zio.aws.devicefarm.model.CreateInstanceProfileResponse.ReadOnly
      ]
  object ListTestGridSessionArtifacts
      extends Effect[
        ListTestGridSessionArtifactsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.ReadOnly
      ]
  object DeleteTestGridProject
      extends Effect[
        DeleteTestGridProjectRequest,
        AwsError,
        zio.aws.devicefarm.model.DeleteTestGridProjectResponse.ReadOnly
      ]
  object DeleteProject
      extends Effect[
        DeleteProjectRequest,
        AwsError,
        zio.aws.devicefarm.model.DeleteProjectResponse.ReadOnly
      ]
  object GetAccountSettings
      extends Effect[
        GetAccountSettingsRequest,
        AwsError,
        zio.aws.devicefarm.model.GetAccountSettingsResponse.ReadOnly
      ]
  object CreateVPCEConfiguration
      extends Effect[
        CreateVpceConfigurationRequest,
        AwsError,
        zio.aws.devicefarm.model.CreateVpceConfigurationResponse.ReadOnly
      ]
  object GetTestGridSession
      extends Effect[
        GetTestGridSessionRequest,
        AwsError,
        zio.aws.devicefarm.model.GetTestGridSessionResponse.ReadOnly
      ]
  object ListVPCEConfigurations
      extends Effect[
        ListVpceConfigurationsRequest,
        AwsError,
        zio.aws.devicefarm.model.ListVpceConfigurationsResponse.ReadOnly
      ]
  object RenewOffering
      extends Effect[
        RenewOfferingRequest,
        AwsError,
        zio.aws.devicefarm.model.RenewOfferingResponse.ReadOnly
      ]
  object GetDevice
      extends Effect[
        GetDeviceRequest,
        AwsError,
        zio.aws.devicefarm.model.GetDeviceResponse.ReadOnly
      ]
  object CreateNetworkProfile
      extends Effect[
        CreateNetworkProfileRequest,
        AwsError,
        zio.aws.devicefarm.model.CreateNetworkProfileResponse.ReadOnly
      ]
  object ListSamples
      extends Stream[
        ListSamplesRequest,
        AwsError,
        zio.aws.devicefarm.model.Sample.ReadOnly
      ]
  object ListSamplesPaginated
      extends Effect[
        ListSamplesRequest,
        AwsError,
        zio.aws.devicefarm.model.ListSamplesResponse.ReadOnly
      ]
  object CreateUpload
      extends Effect[
        CreateUploadRequest,
        AwsError,
        zio.aws.devicefarm.model.CreateUploadResponse.ReadOnly
      ]
  object GetDevicePool
      extends Effect[
        GetDevicePoolRequest,
        AwsError,
        zio.aws.devicefarm.model.GetDevicePoolResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, DeviceFarm] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new DeviceFarm {
          val api: DeviceFarmAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : DeviceFarm = this
          def listTestGridSessionActions(
              request: ListTestGridSessionActionsRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.ListTestGridSessionActionsResponse.ReadOnly
          ] = proxy(ListTestGridSessionActions, request)
          def listTestGridSessions(request: ListTestGridSessionsRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListTestGridSessionsResponse.ReadOnly
          ] = proxy(ListTestGridSessions, request)
          def getProject(request: GetProjectRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.GetProjectResponse.ReadOnly
          ] = proxy(GetProject, request)
          def updateInstanceProfile(request: UpdateInstanceProfileRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.UpdateInstanceProfileResponse.ReadOnly
          ] = proxy(UpdateInstanceProfile, request)
          def listTestGridProjects(request: ListTestGridProjectsRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListTestGridProjectsResponse.ReadOnly
          ] = proxy(ListTestGridProjects, request)
          def updateDeviceInstance(request: UpdateDeviceInstanceRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.UpdateDeviceInstanceResponse.ReadOnly
          ] = proxy(UpdateDeviceInstance, request)
          def installToRemoteAccessSession(
              request: InstallToRemoteAccessSessionRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse.ReadOnly
          ] = proxy(InstallToRemoteAccessSession, request)
          def updateTestGridProject(
              request: UpdateTestGridProjectRequest
          ): IO[AwsError, ReadOnly] = proxy(UpdateTestGridProject, request)
          def updateVPCEConfiguration(
              request: UpdateVpceConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.UpdateVpceConfigurationResponse.ReadOnly
          ] = proxy(UpdateVPCEConfiguration, request)
          def getUpload(
              request: GetUploadRequest
          ): IO[AwsError, zio.aws.devicefarm.model.GetUploadResponse.ReadOnly] =
            proxy(GetUpload, request)
          def updateProject(request: UpdateProjectRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.UpdateProjectResponse.ReadOnly
          ] = proxy(UpdateProject, request)
          def updateNetworkProfile(request: UpdateNetworkProfileRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.UpdateNetworkProfileResponse.ReadOnly
          ] = proxy(UpdateNetworkProfile, request)
          def updateUpload(request: UpdateUploadRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.UpdateUploadResponse.ReadOnly
          ] = proxy(UpdateUpload, request)
          def createTestGridUrl(request: CreateTestGridUrlRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.CreateTestGridUrlResponse.ReadOnly
          ] = proxy(CreateTestGridUrl, request)
          def getRun(
              request: GetRunRequest
          ): IO[AwsError, zio.aws.devicefarm.model.GetRunResponse.ReadOnly] =
            proxy(GetRun, request)
          def listDeviceInstances(request: ListDeviceInstancesRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListDeviceInstancesResponse.ReadOnly
          ] = proxy(ListDeviceInstances, request)
          def listSuites(
              request: ListSuitesRequest
          ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Suite.ReadOnly] =
            rts.unsafeRun(proxy(ListSuites, request))
          def listSuitesPaginated(request: ListSuitesRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListSuitesResponse.ReadOnly
          ] = proxy(ListSuitesPaginated, request)
          def deleteRemoteAccessSession(
              request: DeleteRemoteAccessSessionRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.DeleteRemoteAccessSessionResponse.ReadOnly
          ] = proxy(DeleteRemoteAccessSession, request)
          def getVPCEConfiguration(request: GetVpceConfigurationRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.GetVpceConfigurationResponse.ReadOnly
          ] = proxy(GetVPCEConfiguration, request)
          def stopJob(
              request: StopJobRequest
          ): IO[AwsError, zio.aws.devicefarm.model.StopJobResponse.ReadOnly] =
            proxy(StopJob, request)
          def getNetworkProfile(request: GetNetworkProfileRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.GetNetworkProfileResponse.ReadOnly
          ] = proxy(GetNetworkProfile, request)
          def createDevicePool(request: CreateDevicePoolRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.CreateDevicePoolResponse.ReadOnly
          ] = proxy(CreateDevicePool, request)
          def listDevices(
              request: ListDevicesRequest
          ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Device.ReadOnly] =
            rts.unsafeRun(proxy(ListDevices, request))
          def listDevicesPaginated(request: ListDevicesRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListDevicesResponse.ReadOnly
          ] = proxy(ListDevicesPaginated, request)
          def getRemoteAccessSession(
              request: GetRemoteAccessSessionRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.GetRemoteAccessSessionResponse.ReadOnly
          ] = proxy(GetRemoteAccessSession, request)
          def listRemoteAccessSessions(
              request: ListRemoteAccessSessionsRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse.ReadOnly
          ] = proxy(ListRemoteAccessSessions, request)
          def listProjects(
              request: ListProjectsRequest
          ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Project.ReadOnly] =
            rts.unsafeRun(proxy(ListProjects, request))
          def listProjectsPaginated(request: ListProjectsRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListProjectsResponse.ReadOnly
          ] = proxy(ListProjectsPaginated, request)
          def scheduleRun(request: ScheduleRunRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ScheduleRunResponse.ReadOnly
          ] = proxy(ScheduleRun, request)
          def getDevicePoolCompatibility(
              request: GetDevicePoolCompatibilityRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse.ReadOnly
          ] = proxy(GetDevicePoolCompatibility, request)
          def listUploads(
              request: ListUploadsRequest
          ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Upload.ReadOnly] =
            rts.unsafeRun(proxy(ListUploads, request))
          def listUploadsPaginated(request: ListUploadsRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListUploadsResponse.ReadOnly
          ] = proxy(ListUploadsPaginated, request)
          def deleteUpload(request: DeleteUploadRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.DeleteUploadResponse.ReadOnly
          ] = proxy(DeleteUpload, request)
          def listRuns(
              request: ListRunsRequest
          ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Run.ReadOnly] =
            rts.unsafeRun(proxy(ListRuns, request))
          def listRunsPaginated(
              request: ListRunsRequest
          ): IO[AwsError, zio.aws.devicefarm.model.ListRunsResponse.ReadOnly] =
            proxy(ListRunsPaginated, request)
          def updateDevicePool(request: UpdateDevicePoolRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.UpdateDevicePoolResponse.ReadOnly
          ] = proxy(UpdateDevicePool, request)
          def listArtifacts(request: ListArtifactsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.devicefarm.model.Artifact.ReadOnly
          ] = rts.unsafeRun(proxy(ListArtifacts, request))
          def listArtifactsPaginated(request: ListArtifactsRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListArtifactsResponse.ReadOnly
          ] = proxy(ListArtifactsPaginated, request)
          def getTestGridProject(request: GetTestGridProjectRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.GetTestGridProjectResponse.ReadOnly
          ] = proxy(GetTestGridProject, request)
          def stopRemoteAccessSession(
              request: StopRemoteAccessSessionRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.StopRemoteAccessSessionResponse.ReadOnly
          ] = proxy(StopRemoteAccessSession, request)
          def listDevicePools(request: ListDevicePoolsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.devicefarm.model.DevicePool.ReadOnly
          ] = rts.unsafeRun(proxy(ListDevicePools, request))
          def listDevicePoolsPaginated(request: ListDevicePoolsRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListDevicePoolsResponse.ReadOnly
          ] = proxy(ListDevicePoolsPaginated, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def createProject(request: CreateProjectRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.CreateProjectResponse.ReadOnly
          ] = proxy(CreateProject, request)
          def createRemoteAccessSession(
              request: CreateRemoteAccessSessionRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.CreateRemoteAccessSessionResponse.ReadOnly
          ] = proxy(CreateRemoteAccessSession, request)
          def stopRun(
              request: StopRunRequest
          ): IO[AwsError, zio.aws.devicefarm.model.StopRunResponse.ReadOnly] =
            proxy(StopRun, request)
          def listUniqueProblems(request: ListUniqueProblemsRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListUniqueProblemsResponse.ReadOnly
          ] = proxy(ListUniqueProblems, request)
          def getJob(
              request: GetJobRequest
          ): IO[AwsError, zio.aws.devicefarm.model.GetJobResponse.ReadOnly] =
            proxy(GetJob, request)
          def listOfferingTransactions(
              request: ListOfferingTransactionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.devicefarm.model.OfferingTransaction.ReadOnly
          ] = rts.unsafeRun(proxy(ListOfferingTransactions, request))
          def listOfferingTransactionsPaginated(
              request: ListOfferingTransactionsRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.ListOfferingTransactionsResponse.ReadOnly
          ] = proxy(ListOfferingTransactionsPaginated, request)
          def listOfferings(request: ListOfferingsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.devicefarm.model.Offering.ReadOnly
          ] = rts.unsafeRun(proxy(ListOfferings, request))
          def listOfferingsPaginated(request: ListOfferingsRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListOfferingsResponse.ReadOnly
          ] = proxy(ListOfferingsPaginated, request)
          def deleteInstanceProfile(request: DeleteInstanceProfileRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.DeleteInstanceProfileResponse.ReadOnly
          ] = proxy(DeleteInstanceProfile, request)
          def createTestGridProject(request: CreateTestGridProjectRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.CreateTestGridProjectResponse.ReadOnly
          ] = proxy(CreateTestGridProject, request)
          def listOfferingPromotions(
              request: ListOfferingPromotionsRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.ListOfferingPromotionsResponse.ReadOnly
          ] = proxy(ListOfferingPromotions, request)
          def getSuite(
              request: GetSuiteRequest
          ): IO[AwsError, zio.aws.devicefarm.model.GetSuiteResponse.ReadOnly] =
            proxy(GetSuite, request)
          def getOfferingStatus(request: GetOfferingStatusRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.GetOfferingStatusResponse.ReadOnly
          ] = proxy(GetOfferingStatus, request)
          def deleteVPCEConfiguration(
              request: DeleteVpceConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.DeleteVpceConfigurationResponse.ReadOnly
          ] = proxy(DeleteVPCEConfiguration, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def listJobs(
              request: ListJobsRequest
          ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Job.ReadOnly] =
            rts.unsafeRun(proxy(ListJobs, request))
          def listJobsPaginated(
              request: ListJobsRequest
          ): IO[AwsError, zio.aws.devicefarm.model.ListJobsResponse.ReadOnly] =
            proxy(ListJobsPaginated, request)
          def deleteRun(
              request: DeleteRunRequest
          ): IO[AwsError, zio.aws.devicefarm.model.DeleteRunResponse.ReadOnly] =
            proxy(DeleteRun, request)
          def deleteDevicePool(request: DeleteDevicePoolRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.DeleteDevicePoolResponse.ReadOnly
          ] = proxy(DeleteDevicePool, request)
          def getInstanceProfile(request: GetInstanceProfileRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.GetInstanceProfileResponse.ReadOnly
          ] = proxy(GetInstanceProfile, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def listTests(
              request: ListTestsRequest
          ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Test.ReadOnly] =
            rts.unsafeRun(proxy(ListTests, request))
          def listTestsPaginated(
              request: ListTestsRequest
          ): IO[AwsError, zio.aws.devicefarm.model.ListTestsResponse.ReadOnly] =
            proxy(ListTestsPaginated, request)
          def deleteNetworkProfile(request: DeleteNetworkProfileRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.DeleteNetworkProfileResponse.ReadOnly
          ] = proxy(DeleteNetworkProfile, request)
          def purchaseOffering(request: PurchaseOfferingRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.PurchaseOfferingResponse.ReadOnly
          ] = proxy(PurchaseOffering, request)
          def listInstanceProfiles(request: ListInstanceProfilesRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListInstanceProfilesResponse.ReadOnly
          ] = proxy(ListInstanceProfiles, request)
          def getTest(
              request: GetTestRequest
          ): IO[AwsError, zio.aws.devicefarm.model.GetTestResponse.ReadOnly] =
            proxy(GetTest, request)
          def listNetworkProfiles(request: ListNetworkProfilesRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListNetworkProfilesResponse.ReadOnly
          ] = proxy(ListNetworkProfiles, request)
          def getDeviceInstance(request: GetDeviceInstanceRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.GetDeviceInstanceResponse.ReadOnly
          ] = proxy(GetDeviceInstance, request)
          def createInstanceProfile(request: CreateInstanceProfileRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.CreateInstanceProfileResponse.ReadOnly
          ] = proxy(CreateInstanceProfile, request)
          def listTestGridSessionArtifacts(
              request: ListTestGridSessionArtifactsRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.ReadOnly
          ] = proxy(ListTestGridSessionArtifacts, request)
          def deleteTestGridProject(request: DeleteTestGridProjectRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.DeleteTestGridProjectResponse.ReadOnly
          ] = proxy(DeleteTestGridProject, request)
          def deleteProject(request: DeleteProjectRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.DeleteProjectResponse.ReadOnly
          ] = proxy(DeleteProject, request)
          def getAccountSettings(request: GetAccountSettingsRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.GetAccountSettingsResponse.ReadOnly
          ] = proxy(GetAccountSettings, request)
          def createVPCEConfiguration(
              request: CreateVpceConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.CreateVpceConfigurationResponse.ReadOnly
          ] = proxy(CreateVPCEConfiguration, request)
          def getTestGridSession(request: GetTestGridSessionRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.GetTestGridSessionResponse.ReadOnly
          ] = proxy(GetTestGridSession, request)
          def listVPCEConfigurations(
              request: ListVpceConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.devicefarm.model.ListVpceConfigurationsResponse.ReadOnly
          ] = proxy(ListVPCEConfigurations, request)
          def renewOffering(request: RenewOfferingRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.RenewOfferingResponse.ReadOnly
          ] = proxy(RenewOffering, request)
          def getDevice(
              request: GetDeviceRequest
          ): IO[AwsError, zio.aws.devicefarm.model.GetDeviceResponse.ReadOnly] =
            proxy(GetDevice, request)
          def createNetworkProfile(request: CreateNetworkProfileRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.CreateNetworkProfileResponse.ReadOnly
          ] = proxy(CreateNetworkProfile, request)
          def listSamples(
              request: ListSamplesRequest
          ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Sample.ReadOnly] =
            rts.unsafeRun(proxy(ListSamples, request))
          def listSamplesPaginated(request: ListSamplesRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.ListSamplesResponse.ReadOnly
          ] = proxy(ListSamplesPaginated, request)
          def createUpload(request: CreateUploadRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.CreateUploadResponse.ReadOnly
          ] = proxy(CreateUpload, request)
          def getDevicePool(request: GetDevicePoolRequest): IO[
            AwsError,
            zio.aws.devicefarm.model.GetDevicePoolResponse.ReadOnly
          ] = proxy(GetDevicePool, request)
        }
      }
    }
    .toLayer
}
